/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.model;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.model.document.AbstractIndexDocument;
import eu.dnetlib.clients.index.model.document.IndexField;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;

public class SolrIndexDocument
extends AbstractIndexDocument {
    public SolrIndexDocument(Map<String, Any.ValueType> schema, String dsId) {
        super(schema, dsId);
    }

    public SolrIndexDocument(Map<String, Any.ValueType> schema, String dsId, SolrInputDocument solrDocument) {
        super(schema, dsId);
        this.addFields(solrDocument);
    }

    private void addFields(SolrInputDocument solrDocument) {
        for (String name : solrDocument.getFieldNames()) {
            Collection fieldValues = solrDocument.getFieldValues(name);
            if (fieldValues.size() > 1) {
                this.addField(name, fieldValues);
                continue;
            }
            if (fieldValues.size() != 1) continue;
            this.addField(name, fieldValues.iterator().next());
        }
    }

    public void setContent(SolrInputDocument solrDocument) {
        this.addFields(solrDocument);
    }

    public SolrInputDocument getSolrDocument() {
        HashMap<String, SolrInputField> data = new HashMap<String, SolrInputField>();
        for (String key : this.fields.keySet()) {
            SolrInputField solrField = new SolrInputField(key);
            for (Object o : (IndexField)this.fields.get(key)) {
                solrField.addValue(o);
            }
            data.put(key, solrField);
        }
        return new SolrInputDocument(data);
    }
}

