/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.actions;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.oai.actions.AbstractOAIStoreAction;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.utils.OAIParameterNames;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DropStoreAction
extends AbstractOAIStoreAction {
    private static final Log log = LogFactory.getLog(DropStoreAction.class);
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        String mdformat = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_NAME);
        String layout = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_LAYOUT);
        String interp = (String)job.getParameters().get(OAIParameterNames.OAI_FORMAT_INTERPRETATION);
        String dbName = (String)job.getParameters().get(OAIParameterNames.OAI_DB);
        String coll = (String)job.getParameters().get(OAIParameterNames.OAI_COLLECTON);
        String set = (String)job.getParameters().get(OAIParameterNames.OAI_SOURCE);
        boolean deleted = false;
        deleted = StringUtils.isNotBlank((CharSequence)set) ? this.mongoPublisherStoreDAO.deleteFromStore(mdformat, interp, layout, dbName, set) : this.mongoPublisherStoreDAO.deleteStore(mdformat, interp, layout, dbName);
        if (deleted) {
            log.info((Object)("OAI Deletion succeeded on db " + dbName + " oaistore: " + coll + ", for set (all if empty) : " + set));
        } else {
            log.info((Object)("Probably the store to delete " + coll + " does not exist. OAI Deletion failed on db " + dbName));
        }
        handler.done(job);
    }
}

