/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.conf;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.conf.OAIConfigurationReader;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.common.UnimplementedException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import eu.dnetlib.utils.MetadataReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class OAIConfigurationExistReader
implements OAIConfigurationReader {
    @Autowired
    private ISLookUpClient lookupClient;
    private String xpathToIdScheme = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/IDSCHEME/text()";
    private String xpathToIdNamespace = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION/IDNAMESPACE/text()";

    @Override
    public List<SetInfo> getSets() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
        try {
            return this.lookupClient.searchAndMapToClassByConstructor("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())", SetInfo.class, ":-:");
        }
        catch (ISLookUpException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SetInfo> getSets(boolean onlyEnabled) {
        if (onlyEnabled) {
            String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
            try {
                return this.lookupClient.searchAndMapToClassByConstructor("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = 'true' return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())", SetInfo.class, ":-:");
            }
            catch (ISLookUpException e) {
                throw new RuntimeException(e);
            }
        }
        return this.getSets();
    }

    @Override
    public List<String> getSetSpecs() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return $x/spec/string() ";
        try {
            return this.lookupClient.search("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET return $x/spec/string() ");
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> getSetSpecs(boolean onlyEnabled) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/@enabled/string() = '" + onlyEnabled + "' return $x/spec/string() ";
        try {
            return this.lookupClient.search(query);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public SetInfo getSetInfo(String setSpec) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET where $x/spec = '" + setSpec + "' return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
        try {
            List info = this.lookupClient.searchAndMapToClassByConstructor(query, SetInfo.class, ":-:");
            if (info != null && info.size() > 0) {
                return (SetInfo)info.get(0);
            }
            return null;
        }
        catch (Throwable e) {
            throw new OaiPublisherRuntimeException(e);
        }
    }

    @Override
    public List<MetadataReference> getSourceMetadataFormats() {
        List res;
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string())";
        try {
            res = this.lookupClient.search("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string())");
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        HashSet sources = new HashSet();
        res.forEach(src -> {
            String[] splitted = src.split(":-:");
            MetadataReference mdref = new MetadataReference(splitted[0], splitted[1], splitted[2]);
            sources.add(mdref);
        });
        return sources.stream().collect(Collectors.toList());
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo() {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
        try {
            return this.lookupClient.searchAndMapToClassByConstructor("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )", MDFInfo.class, ":-:");
        }
        catch (Throwable e) {
            throw new OaiPublisherRuntimeException(e);
        }
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo(boolean onlyEnabled) {
        if (onlyEnabled) {
            String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@exportable/string() = 'true' return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
            try {
                return this.lookupClient.searchAndMapToClassByConstructor("for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@exportable/string() = 'true' return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )", MDFInfo.class, ":-:");
            }
            catch (Throwable e) {
                throw new OaiPublisherRuntimeException(e);
            }
        }
        return this.getMetadataFormatInfo();
    }

    @Override
    public MDFInfo getMetadataFormatInfo(String mdPrefix) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT where $x/@metadataPrefix/string()='" + mdPrefix + "' return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY,':-:', $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
        try {
            List mdfInfos = this.lookupClient.searchAndMapToClassByConstructor(query, MDFInfo.class, ":-:");
            if (mdfInfos != null && mdfInfos.size() > 0) {
                return (MDFInfo)mdfInfos.get(0);
            }
            return null;
        }
        catch (Throwable e) {
            throw new OaiPublisherRuntimeException(e);
        }
    }

    @Override
    public List<PublisherField> getFields() {
        throw new UnimplementedException();
    }

    @Override
    public List<PublisherField> getFields(String format, String interpretation, String layout) {
        List res;
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//INDICES/INDEX return concat($x/@name, ':-:', $x/@repeatable, ':-:', string-join($x/SOURCE[@name='" + format + "' and @interpretation='" + interpretation + "' and @layout='" + layout + "']/@path, ':-:'))";
        try {
            res = this.lookupClient.search(query);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        ArrayList<PublisherField> fields = new ArrayList<PublisherField>();
        for (String index : res) {
            String[] splitted = index.split(":-:");
            String indexName = splitted[0];
            String repeatable = splitted[1];
            PublisherField field = new PublisherField();
            field.setFieldName(indexName);
            field.setRepeatable(Boolean.valueOf(repeatable));
            ArrayListMultimap sources = ArrayListMultimap.create();
            String mdFormat = format + "-" + layout + "-" + interpretation;
            for (int i = 2; i < splitted.length; ++i) {
                sources.put((Object)mdFormat, (Object)splitted[i]);
            }
            field.setSources((Multimap<String, String>)sources);
            fields.add(field);
        }
        return fields;
    }

    @Override
    public List<String> getFieldNames() {
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDICES/INDEX/@name/string()";
        try {
            return this.lookupClient.search("//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDICES/INDEX/@name/string()");
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<MDFInfo> getFormatsServedBy(String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation) {
        String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT[.//SOURCE_METADATA_FORMAT/@name = '" + sourceFormatName + "' and .//SOURCE_METADATA_FORMAT/@layout = '" + sourceFormatLayout + "' and .//SOURCE_METADATA_FORMAT/@interpretation = '" + sourceFormatInterpretation + "'] return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  ':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), ':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
        try {
            return this.lookupClient.searchAndMapToClassByConstructor(query, MDFInfo.class, ":-:");
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getIdScheme() {
        try {
            return this.lookupClient.getResourceProfileByQuery(this.getXpathToIdScheme());
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getIdNamespace() {
        try {
            return this.lookupClient.getResourceProfileByQuery(this.getXpathToIdNamespace());
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
    }

    public ISLookUpClient getLookupClient() {
        return this.lookupClient;
    }

    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public String getXpathToIdScheme() {
        return this.xpathToIdScheme;
    }

    public void setXpathToIdScheme(String xpathToIdScheme) {
        this.xpathToIdScheme = xpathToIdScheme;
    }

    public String getXpathToIdNamespace() {
        return this.xpathToIdNamespace;
    }

    public void setXpathToIdNamespace(String xpathToIdNamespace) {
        this.xpathToIdNamespace = xpathToIdNamespace;
    }
}

