/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.clients.enabling.ISLookUpClient;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import eu.dnetlib.oai.conf.OAIConfigurationExistReader;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherException;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import java.util.List;
import java.util.function.Function;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

public class OAIISLookUpClient {
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);
    @Value(value="${services.oai.publisher.db.xquery}")
    private String xpathToCurrentDB;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Autowired
    private OAIConfigurationExistReader configuration;
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    public List<MDFInfo> listMetadataFormats(boolean onlyEnabled) throws ISLookUpException, DocumentException, OaiPublisherException {
        return Lists.newArrayList(this.configuration.getMetadataFormatInfo(onlyEnabled));
    }

    @Cacheable(value={"unaryFunctions"}, key="#tdsRuleId")
    public Function<String, String> getUnaryFunctionFromTDSRule(String tdsRuleId) {
        log.fatal((Object)("Not using cache to get TDSRule " + tdsRuleId));
        String queryCodeRule = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsRuleId + "']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
        String xsltCode = null;
        try {
            xsltCode = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(queryCodeRule);
        }
        catch (Throwable e) {
            log.fatal((Object)("Unexisting TDSRule profile with identifier " + tdsRuleId));
            throw new OaiPublisherRuntimeException(e);
        }
        if (StringUtils.isBlank((CharSequence)xsltCode)) {
            log.warn((Object)("Unexpected blank stylesheet in TDSRule profile with id: " + tdsRuleId + ". Returning identity function."));
            return it -> it;
        }
        return new ApplyXslt(xsltCode, this.saxonTransformerFactory);
    }

    @Cacheable(value={"oaiDB"})
    public String getCurrentDB() throws ISLookUpException {
        log.fatal((Object)"Not using cache to get the current OAI db");
        String currentDBName = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(this.xpathToCurrentDB);
        log.info((Object)("Current OAI DB:" + currentDBName));
        return currentDBName;
    }

    @CacheEvict(value={"unaryFunctions", "oaiDB"}, allEntries=true, beforeInvocation=true)
    public void evictCaches() {
        log.info((Object)"Evicted caches oaiDB and unaryFunctions");
    }

    public OAIConfigurationExistReader getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(OAIConfigurationExistReader configuration) {
        this.configuration = configuration;
    }
}

