/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.solr.model.SolrIndexDocument;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class SolrIndexCollection
implements IndexCollection {
    private static final Log log = LogFactory.getLog(SolrIndexCollection.class);
    public static final int STATUS_INDEX_OK = 0;
    private CloudSolrClient client;
    private boolean shutdown = false;

    public SolrIndexCollection(CloudSolrClient newServer) {
        this.client = newServer;
        this.client.connect();
    }

    @Override
    public boolean add(IndexDocument doc) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        SolrIndexDocument solrDocument = (SolrIndexDocument)doc;
        try {
            UpdateResponse response = this.client.add(solrDocument.getSolrDocument());
            return response.getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to add document", (Throwable)e);
        }
    }

    @Override
    public boolean addAll(Iterator<IndexDocument> docs) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        Iterator solrDocs = Iterators.transform(docs, (Function)new Function<IndexDocument, SolrInputDocument>(){

            public SolrInputDocument apply(IndexDocument doc) {
                SolrIndexDocument solrDocument = (SolrIndexDocument)doc;
                return solrDocument.getSolrDocument();
            }
        });
        try {
            UpdateResponse response = this.client.add((Collection)Lists.newArrayList((Iterator)solrDocs));
            return response.getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("Unable to add document", (Throwable)e);
        }
    }

    @Override
    public boolean addAll(Collection<IndexDocument> docs) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        return this.addAll(docs.iterator());
    }

    @Override
    public boolean deleteIndex(String dsId) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        return this.doDelete("__dsid : \"" + dsId + "\"");
    }

    @Override
    public boolean deleteByQuery(String query, String dsId) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        if (StringUtils.isBlank((CharSequence)dsId)) {
            return this.doDelete(query);
        }
        return this.doDelete(query + " AND " + "__dsid" + " : \"" + dsId + "\"");
    }

    protected boolean doDelete(String query) throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        try {
            log.debug((Object)("delete by query: " + query));
            return this.client.deleteByQuery(query).getStatus() == 0;
        }
        catch (Exception e) {
            throw new IndexServiceException("unable to run delete by query: " + query, (Throwable)e);
        }
    }

    @Override
    public boolean commit() throws IndexServiceException {
        if (this.isShutdown()) {
            throw new IndexServiceException("Please get another SolrIndexCollection: this has been shut down");
        }
        try {
            log.info((Object)"performing commit");
            UpdateResponse rsp = this.client.commit();
            log.info((Object)String.format("commit completed in %s, status %s", rsp.getElapsedTime(), rsp.getStatus()));
            return rsp.getStatus() == 0;
        }
        catch (Throwable e) {
            throw new IndexServiceException("unable to perform index commit", e);
        }
    }

    @Override
    public void shutdown() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }
}

