/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr;

import com.google.common.collect.Maps;
import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.query.IndexQueryFactory;
import eu.dnetlib.cql.CqlValueTransformerMap;
import eu.dnetlib.index.AbstractBackendDescriptor;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.IndexServerDAO;
import eu.dnetlib.index.feed.DocumentMapperFactory;
import eu.dnetlib.index.query.SolrIndexQueryFactory;
import eu.dnetlib.index.query.SolrIndexQueryResponseFactory;
import eu.dnetlib.index.solr.SolrIndexCollection;
import eu.dnetlib.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.index.solr.feed.SolrDocumentMapperFactory;
import eu.dnetlib.index.utils.IndexConfigFactory;
import eu.dnetlib.index.utils.RemoteSolrAdministrator;
import eu.dnetlib.index.utils.ZkServers;
import eu.dnetlib.index.utils.ZkUtils;
import eu.dnetlib.rmi.provision.IndexServiceException;
import eu.dnetlib.utils.MetadataReference;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SolrIndexServerDAO
extends AbstractBackendDescriptor
implements IndexServerDAO {
    private static final Log log = LogFactory.getLog(SolrIndexServerDAO.class);
    @Autowired
    private ZkUtils zkUtils;
    @Autowired
    private SolrIndexQueryResponseFactory queryResponseFactory;
    @Autowired
    private SolrIndexQueryFactory solrIndexQueryFactory;
    @Autowired
    private SolrDocumentMapperFactory solrDocumentMapperFactory;
    private RemoteSolrAdministrator solrAdministrator;
    @Autowired
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    @Override
    public void createIndexCollection(MetadataReference mdref, String fields) throws IndexServiceException {
        log.debug((Object)("createIndexCollection  " + mdref.toString() + "   " + fields));
        try (CloudSolrClient client = this.getClient();){
            client.connect();
            if (!this.solrAdministrator.indexCollectionExists(mdref.toString(), client)) {
                HashMap params = Maps.newHashMap();
                Map<String, String> p = this.getServiceProperties();
                params.put("numShards", p.get("numShards"));
                params.put("replicationFactor", p.get("replicationFactor"));
                for (IndexConfigFactory.CONFIG_PARAMS param_Name : IndexConfigFactory.CONFIG_PARAMS.values()) {
                    params.put(param_Name.toString(), p.get(param_Name.toString()));
                }
                this.zkUtils.uploadZookeperConfig(client.getZkStateReader().getZkClient(), mdref.toString(), this.parse(fields), params, true);
                this.solrAdministrator.createSolrIndex(p.get("host"), p.get("port"), mdref.toString(), p.get("numShards"), p.get("replicationFactor"), mdref.toString(), p.get("maxShardsPerNode"));
            }
            client.getZkStateReader().close();
        }
        catch (Exception e) {
            log.error((Object)"Error on creating IndexCollection", (Throwable)e);
            throw new IndexServiceException("Error on creating IndexCollection", (Throwable)e);
        }
    }

    @Override
    public void updateIndexCollection(MetadataReference mdRef, Document fields) throws IndexServiceException {
        try (CloudSolrClient client = this.getClient();){
            client.connect();
            HashMap params = Maps.newHashMap();
            params.put("numShards", this.getServiceProperties().get("numShards"));
            params.put("replicationFactor", this.getServiceProperties().get("replicationFactor"));
            for (IndexConfigFactory.CONFIG_PARAMS param_Name : IndexConfigFactory.CONFIG_PARAMS.values()) {
                params.put(param_Name.toString(), this.getServiceProperties().get(param_Name.toString()));
            }
            this.zkUtils.uploadZookeperConfig(client.getZkStateReader().getZkClient(), mdRef.toString(), fields, params, true);
            client.getZkStateReader().close();
            this.solrAdministrator.reloadCollection(this.getServiceProperties().get("host"), this.getServiceProperties().get("port"), mdRef.toString());
        }
        catch (Exception e) {
            log.error((Object)"Error on updating IndexCollection", (Throwable)e);
            throw new IndexServiceException("Error on updating IndexCollection", (Throwable)e);
        }
    }

    private Document parse(String fields) throws IndexServiceException {
        try {
            return new SAXReader().read((Reader)new StringReader(fields));
        }
        catch (DocumentException e) {
            throw new IndexServiceException("unable to parse fields: " + fields, (Throwable)e);
        }
    }

    @Override
    public IndexCollection getIndexCollection(MetadataReference mdref) throws IndexServiceException {
        CloudSolrClient client = this.getClient(mdref);
        return new SolrIndexCollection(client);
    }

    @Override
    public Map<String, Any.ValueType> getSchema(MetadataReference mdRef) throws IndexServiceException {
        CloudSolrClient client = this.getClient(mdRef);
        Map<String, Any.ValueType> fields = this.solrAdministrator.getFieldNamesAndTypes(mdRef.toString(), (SolrClient)client);
        this.shutdown(mdRef);
        return fields;
    }

    @Override
    public CqlValueTransformerMap getCqlValueTransformerMap(MetadataReference mdRef) throws IndexServiceException {
        return this.tMapFactory.getIt(this.getSchema(mdRef));
    }

    @Override
    public DocumentMapperFactory getDocumentMapperFactory() throws IndexServiceException {
        return this.solrDocumentMapperFactory;
    }

    @Override
    public void shutdown(MetadataReference mdRef) throws IndexServiceException {
        try {
            this.getClient(mdRef).close();
        }
        catch (IOException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    private CloudSolrClient getClient(MetadataReference mdRef) throws IndexServiceException {
        CloudSolrClient client = this.getClient();
        client.setDefaultCollection(mdRef.toString());
        return client;
    }

    private CloudSolrClient getClient() {
        String address = this.getEndpoint().get("address");
        log.info((Object)("connecting to address: " + address));
        ZkServers zk = ZkServers.newInstance(address);
        return new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).build();
    }

    public RemoteSolrAdministrator getSolrAdministrator() {
        return this.solrAdministrator;
    }

    @Required
    public void setSolrAdministrator(RemoteSolrAdministrator solrAdministrator) {
        this.solrAdministrator = solrAdministrator;
    }

    @Override
    public IndexQueryFactory getIndexQueryFactory() {
        return this.solrIndexQueryFactory;
    }
}

