/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.client;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import eu.dnetlib.clients.index.client.AbstractIndexClientFactory;
import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.IndexClientFactory;
import eu.dnetlib.index.query.SolrIndexQueryFactory;
import eu.dnetlib.index.query.SolrIndexQueryResponseFactory;
import eu.dnetlib.index.solr.client.SolrIndexClient;
import eu.dnetlib.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.utils.MetadataReference;
import eu.dnetlib.utils.MetadataReferenceFactory;
import java.lang.reflect.Type;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class SolrIndexClientFactory
extends AbstractIndexClientFactory
implements IndexClientFactory {
    private static String ID = "id";
    private String configuration;
    protected Type typeToken = new TypeToken<Map<String, String>>(){}.getType();
    private Map<String, String> serviceProperties;
    @Autowired
    private SolrIndexQueryFactory solrIndexQueryFactory;
    @Autowired
    private SolrIndexQueryResponseFactory solrIndexQueryResponseFactory;
    @Autowired
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    public void init() throws IndexClientException {
        try {
            this.serviceProperties = (Map)new Gson().fromJson(this.getConfiguration(), this.typeToken);
        }
        catch (Throwable e) {
            throw new IndexClientException("unable to parse configuration: " + this.getConfiguration(), e);
        }
    }

    public String getBackendId() {
        return this.serviceProperties.get(ID);
    }

    public IndexClient getClient(String format, String layout, String interpretation) throws IndexClientException {
        return new SolrIndexClient(format, layout, interpretation, this.isQueryTools.getIndexProperties(this.getBackendId()), this.solrIndexQueryFactory, this.solrIndexQueryResponseFactory, this.tMapFactory);
    }

    public IndexClient getClient(MetadataReference mdRef) throws IndexClientException {
        return this.getClient(mdRef.getFormat(), mdRef.getLayout(), mdRef.getInterpretation());
    }

    public IndexClient getClient(String collection) throws IndexClientException {
        return this.getClient(MetadataReferenceFactory.decodeMetadata((String)collection));
    }

    public String getConfiguration() {
        return this.configuration;
    }

    @Required
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }
}

