/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.oai.mongo.MongoPublisherStore;
import eu.dnetlib.oai.mongo.MongoPublisherStoreDAO;
import eu.dnetlib.oai.sets.OAISetsCounter;
import eu.dnetlib.oai.sync.OAIStoreSynchronizer;
import eu.dnetlib.oai.utils.OAIHelper;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OAIStoreService;
import eu.dnetlib.utils.MetadataReference;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class OAIStoreServiceImpl
extends AbstractBaseService
implements OAIStoreService {
    private NotificationHandler notificationHandler;
    @Autowired
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Autowired
    private OAIStoreSynchronizer synchronizer;
    @Resource(name="oaiSetsCounter")
    private OAISetsCounter setsCounter;
    @Autowired
    private OAIHelper oaiHelper;
    @Autowired
    private ResultSetClient resultSetClient;

    public void feed(ResultSet<String> recordsEpr, MetadataReference mdfInfo, String dbName) {
        this.feed(recordsEpr, mdfInfo, "", dbName);
    }

    public void feed(ResultSet<String> recordsEpr, MetadataReference mdfInfo, String recordSource, String dbName) {
        Iterable iter = this.resultSetClient.iter(recordsEpr, String.class);
        this.synchronizer.synchronize(iter, mdfInfo, recordSource, dbName, false, null, null);
    }

    public void updateSetCounts(String dbName) {
        this.setsCounter.updateCounts("", dbName, null, null);
    }

    public void updateSetCounts(MDFInfo mdfInfo, String dbName) {
        this.setsCounter.updateCounts(mdfInfo, dbName, null, null);
    }

    public void refreshConfiguration(String dbName) {
        this.oaiHelper.loadConfiguration(dbName);
    }

    public void ensureIndexes(String dbName) {
        this.mongoPublisherStoreDAO.ensureIndex(dbName);
    }

    public void ensureIndexes(MDFInfo mdfInfo, String dbName) {
        MongoPublisherStore s = this.mongoPublisherStoreDAO.getStore(mdfInfo.getSourceFormat(), mdfInfo.getSourceInterpretation(), mdfInfo.getSourceLayout(), dbName);
        s.ensureIndices();
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public OAIStoreSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(OAIStoreSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public OAISetsCounter getSetsCounter() {
        return this.setsCounter;
    }

    public void setSetsCounter(OAISetsCounter setsCounter) {
        this.setsCounter = setsCounter;
    }

    public OAIHelper getOaiSetHelper() {
        return this.oaiHelper;
    }

    public void setOaiSetHelper(OAIHelper oaiHelper) {
        this.oaiHelper = oaiHelper;
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }
}

