/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.oai.conf;

import com.google.common.collect.Lists;
import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.conf.OAIConfiguration;
import eu.dnetlib.oai.conf.OAIConfigurationParser;
import eu.dnetlib.oai.conf.OAIConfigurationReader;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.rmi.provision.OaiPublisherRuntimeException;
import eu.dnetlib.utils.MetadataReference;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OAIConfigurationStringReader
implements OAIConfigurationReader {
    private static final Log log = LogFactory.getLog(OAIConfigurationStringReader.class);
    private OAIConfiguration oaiConfiguration;
    @Autowired
    private OAIConfigurationParser configurationParser;

    public OAIConfigurationStringReader() {
        this.oaiConfiguration = null;
    }

    public OAIConfigurationStringReader(String profile) {
        this.readConfiguration(profile);
    }

    public void readConfiguration(String profile) {
        log.debug((Object)profile);
        try {
            this.oaiConfiguration = this.configurationParser.getConfiguration(profile);
        }
        catch (IOException e) {
            throw new OaiPublisherRuntimeException("Could not read OAI configuration profile", (Throwable)e);
        }
    }

    public boolean isConfigurationLoaded() {
        return this.oaiConfiguration != null;
    }

    @Override
    public List<SetInfo> getSets() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getSetsMap().values());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<SetInfo> getSets(boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getSetsMap().values().stream().filter(it -> onlyEnabled ? it.isEnabled() : true).collect(Collectors.toList());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getSetSpecs() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getSetsMap().keySet());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getSetSpecs(boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            if (!onlyEnabled) {
                return this.getSetSpecs();
            }
            List<SetInfo> enabled = this.getSets(true);
            return enabled.stream().map(it -> it.getSetSpec()).collect(Collectors.toList());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MetadataReference> getSourceMetadataFormats() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getSourcesMDF().stream().collect(Collectors.toList());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public SetInfo getSetInfo(String setSpec) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getSetsMap().get(setSpec);
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo() {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getMdFormatsMap().values());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getMetadataFormatInfo(boolean onlyEnabled) {
        if (this.isConfigurationLoaded()) {
            if (!onlyEnabled) {
                return this.getMetadataFormatInfo();
            }
            return this.oaiConfiguration.getMdFormatsMap().values().stream().filter(it -> onlyEnabled ? it.isEnabled() : true).collect(Collectors.toList());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public MDFInfo getMetadataFormatInfo(String mdPrefix) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getMdFormatsMap().get(mdPrefix);
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<PublisherField> getFields() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getFields();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<PublisherField> getFields(String format, String interpretation, String layout) {
        if (this.isConfigurationLoaded()) {
            return Lists.newArrayList(this.oaiConfiguration.getFieldsFor(format, layout, interpretation));
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<String> getFieldNames() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getFieldNames();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public List<MDFInfo> getFormatsServedBy(String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation) {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getMdFormatsMap().values().stream().filter(mdf -> mdf.getSourceFormat() == sourceFormatName && mdf.getSourceLayout() == sourceFormatLayout && mdf.getSourceInterpretation() == sourceFormatInterpretation).collect(Collectors.toList());
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public String getIdScheme() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getIdScheme();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    @Override
    public String getIdNamespace() {
        if (this.isConfigurationLoaded()) {
            return this.oaiConfiguration.getIdNamespace();
        }
        throw new OaiPublisherRuntimeException("Configuration is not loaded");
    }

    public OAIConfiguration getOaiConfiguration() {
        return this.oaiConfiguration;
    }

    public void setOaiConfiguration(OAIConfiguration oaiConfiguration) {
        this.oaiConfiguration = oaiConfiguration;
    }

    public OAIConfigurationParser getConfigurationParser() {
        return this.configurationParser;
    }

    public void setConfigurationParser(OAIConfigurationParser configurationParser) {
        this.configurationParser = configurationParser;
    }
}

