package eu.dnetlib.index.solr.feed;

import java.util.Map;
import java.util.function.Function;

import javax.xml.stream.XMLStreamException;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.clients.index.model.Any.ValueType;
import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.clients.index.model.document.Status;
import eu.dnetlib.index.feed.DocumentMapperFactory;
import eu.dnetlib.index.solr.model.SolrIndexDocument;
import eu.dnetlib.utils.MetadataReference;

/**
 * A factory for creating SolrDocumentMapper objects.
 */
public class SolrDocumentMapperFactory implements DocumentMapperFactory {

    protected static final String DNETRESULT = "result";
    /**
     * document factory used for the feed process.
     */
    private InputDocumentFactory documentFactory;


    private Function<String, IndexDocument> getRecordMapper(final Map<String, ValueType> schema,
                                                            final String dsId,
                                                            final String version) {

    	return doc -> {
            SolrIndexDocument indexDocument = new SolrIndexDocument(schema, dsId);
            try {
                indexDocument.setContent(documentFactory.parseDocument(version, doc, dsId, DNETRESULT));
            } catch (XMLStreamException e) {
                return indexDocument.setMarked();
            }
            indexDocument.setStatus(Status.OK);
            return indexDocument;
        };
    }

    @Override
    public Function<String, IndexDocument> getRecordMapper(final Map<String, ValueType> schema, final MetadataReference mdRef, final String dsId, final String version, final boolean emptyResult) {
        if (emptyResult == false) return getRecordMapper(schema, dsId, version);
        else {
            return doc -> {
                SolrIndexDocument indexDocument = new SolrIndexDocument(schema, dsId);
                try {

                    ResultTransformer transformer = new ResultTransformer(ResultTransformer.Mode.empty) {
                        @Override
                        public String apply(String input) {
                            return input;
                        }
                    };
                    indexDocument.setContent(documentFactory.parseDocument(version, doc, dsId, DNETRESULT, transformer));
                } catch (XMLStreamException e) {
                    return indexDocument.setMarked();
                }
                indexDocument.setStatus(Status.OK);
                return indexDocument;
            };
        }
    }

    /**
     * Gets the document factory.
     *
     * @return the documentFactory
     */
    public InputDocumentFactory getDocumentFactory() {
        return documentFactory;
    }

    /**
     * Sets the document factory.
     *
     * @param documentFactory the documentFactory to set
     */
    @Required
    public void setDocumentFactory(final InputDocumentFactory documentFactory) {
        this.documentFactory = documentFactory;
    }

}
