package eu.dnetlib.oai.conf;

import java.util.List;

import eu.dnetlib.oai.PublisherField;
import eu.dnetlib.oai.info.SetInfo;
import eu.dnetlib.rmi.provision.MDFInfo;
import eu.dnetlib.utils.MetadataReference;

public interface OAIConfigurationReader {

	/**
	 * Constant names of fields used by the publisher to store records in the OAIStores. If you want an index over them, you need to specify
	 * it in the OAI Publisher Configuration profile.
	 */
	final static String ID_FIELD = "objIdentifier";

	final static String DATESTAMP_FIELD = "datestamp";

	final static String SET_FIELD = "set";

	final static String DELETED_FIELD = "deleted";

	final static String BODY_FIELD = "body";

	final static String UPDATED_FIELD = "updated";

	final static String LAST_COLLECTION_DATE_FIELD = "lastCollectionDate";

	List<SetInfo> getSets();

	List<SetInfo> getSets(final boolean onlyEnabled);

	List<String> getSetSpecs();

	List<String> getSetSpecs(final boolean onlyEnabled);

	SetInfo getSetInfo(final String setSpec);

	List<MDFInfo> getMetadataFormatInfo();

	List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled);

	MDFInfo getMetadataFormatInfo(final String mdPrefix);

	List<String> getFieldNames();

	List<PublisherField> getFields();

	List<PublisherField> getFields(final String format, final String interpretation, final String layout);

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier.
	 */
	String getIdScheme();

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier.
	 */
	String getIdNamespace();

	List<MetadataReference> getSourceMetadataFormats();

	List<MDFInfo> getFormatsServedBy(String sourceFormatName, String sourceFormatLayout, String sourceFormatInterpretation);

}
