package eu.dnetlib.index.solr.cql;

import java.util.Map;
import java.util.function.Function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;

import eu.dnetlib.clients.index.model.Any.ValueType;
import eu.dnetlib.cql.CqlValueTransformerMap;

/**
 * This class maps the fields in the given index schema with a transformation rule.
 * 
 * @author marko
 * 
 */
public class SolrTypeBasedCqlValueTransformerMap implements CqlValueTransformerMap {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(SolrTypeBasedCqlValueTransformerMap.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Index schema.
	 */
	private final Map<String, ValueType> schema;

	/**
	 * Map of functions.
	 */
	private final Map<String, Function<String, String>> transformerMap;

	/**
	 * Create value transformer map bound to a specific schema
	 * @param schema
	 * @param transformerMap
	 */
	public SolrTypeBasedCqlValueTransformerMap(final Map<String, ValueType> schema, final Map<String, Function<String, String>> transformerMap) {
		this.schema = schema;
		this.transformerMap = transformerMap;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see CqlValueTransformerMap#transformerFor(String)
	 */
	@Override
	public Function<String, String> transformerFor(final String fieldName) {
		try {
			final ValueType field = schema.get(fieldName);

			if (field != null) {
				Function<String, String> res = transformerMap.get(field.name());
				if (res != null) {
					return res;
				}
			}
		} catch (SolrException e) {
			log.debug("cannot find field", e);
		}
		Function<String,String> identityFunction= (String s)->s;
		return identityFunction;
	}

}
