package eu.dnetlib.index.solr.cql;

import java.util.Map;
import java.util.function.Function;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.clients.index.model.Any.ValueType;

/**
 * Factory for the SolrTypeBasedCqlValueTransformerMap class objects
 * 
 * @author claudio
 * 
 */
public class SolrTypeBasedCqlValueTransformerMapFactory {

	/**
	 * Map of functions, injected via spring.
	 */
	private Map<String, Function<String, String>> transformerMap;

	/**
	 * Method returns a new instance of SolrTypeBasedCqlValueTransformerMap.
	 * 
	 * @param schema
	 * @return the SolrTypeBasedCqlValueTransformerMap
	 */
	public SolrTypeBasedCqlValueTransformerMap getIt(final Map<String, ValueType> schema) {
		return new SolrTypeBasedCqlValueTransformerMap(schema, getTransformerMap());
	}

	@Required
	public void setTransformerMap(Map<String, Function<String, String>> transformerMap) {
		this.transformerMap = transformerMap;
	}

	public Map<String, Function<String, String>> getTransformerMap() {
		return transformerMap;
	}

}
