/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.action;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.index.action.AbstractIndexAction;
import eu.dnetlib.index.action.IndexAction;
import eu.dnetlib.index.actors.ActorMap;
import eu.dnetlib.index.actors.BlackboardActorCallback;
import eu.dnetlib.index.actors.IndexFeedActorFactory;
import eu.dnetlib.index.feed.FeedMode;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FeedIndexAction
extends AbstractIndexAction
implements BlackboardServerAction<IndexAction> {
    private static final Log log = LogFactory.getLog(FeedIndexAction.class);
    @Autowired
    private ActorMap actorMap;
    @Autowired
    private IndexFeedActorFactory feedActorFactory;
    @Autowired
    private transient ResultSetClient resultSetClient;

    public void execute(BlackboardServerHandler handler, BlackboardJob job) throws Exception {
        handler.ongoing(job);
        log.info((Object)"FEED job set to ONGOING");
        String epr = this.getEpr(job);
        String triggerId = UUID.randomUUID().toString();
        String dsId = this.getIndexDSId(job);
        FeedMode feedMode = this.getFeedMode(job);
        String backendId = this.getBackend(job);
        boolean emptyResult = this.getEmptyResult(job);
        if (backendId == null) {
            throw new IndexServiceException("No backend identifier information in CREATE message");
        }
        log.debug((Object)("\n\n scheduling resultSet keepalive trigger: " + triggerId + "\n\n"));
        if (!this.actorMap.hasActor(backendId)) {
            this.actorMap.addActor(backendId, this.feedActorFactory.newInstance());
        }
        ResultSet resultSet = ResultSet.fromJson((String)epr);
        Iterable records = this.resultSetClient.iter(resultSet, String.class);
        this.actorMap.getActor(backendId).feedIndex(dsId, feedMode, records, null, this.newBBActorCallback(handler, job), backendId, emptyResult);
    }

    private boolean getEmptyResult(BlackboardJob job) {
        if (job.getParameters().containsKey("emptyResult")) {
            String emptyResult = ((String)job.getParameters().get("emptyResult")).toLowerCase().trim();
            return "true".equals(emptyResult);
        }
        return false;
    }

    private BlackboardActorCallback newBBActorCallback(final BlackboardServerHandler handler, final BlackboardJob job) {
        return new BlackboardActorCallback(){

            @Override
            public void setJobDone(Map<String, String> params) {
                log.info((Object)(job.getAction() + " job set to DONE"));
                job.getParameters().put("added", "" + params.get("added"));
                job.getParameters().put("skipped", "" + params.get("skipped"));
                job.getParameters().put("marked", "" + params.get("marked"));
                job.getParameters().put("time", "" + params.get("time"));
                handler.done(job);
            }

            @Override
            public void setJobFailed(Throwable exception) {
                log.error((Object)(job.getAction() + " job set to FAILED "), exception);
                handler.failed(job, exception);
            }
        };
    }
}

