/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.cql;

import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.cql.CqlValueTransformerMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.SolrException;

public class SolrTypeBasedCqlValueTransformerMap
implements CqlValueTransformerMap {
    private static final Log log = LogFactory.getLog(SolrTypeBasedCqlValueTransformerMap.class);
    private final Map<String, Any.ValueType> schema;
    private final Map<String, Function<String, String>> transformerMap;

    public SolrTypeBasedCqlValueTransformerMap(Map<String, Any.ValueType> schema, Map<String, Function<String, String>> transformerMap) {
        this.schema = schema;
        this.transformerMap = transformerMap;
    }

    public Function<String, String> transformerFor(String fieldName) {
        try {
            Function<String, String> res;
            Any.ValueType field = this.schema.get(fieldName);
            if (field != null && (res = this.transformerMap.get(field.name())) != null) {
                return res;
            }
        }
        catch (SolrException e) {
            log.debug((Object)"cannot find field", (Throwable)e);
        }
        Function<String, String> identityFunction = s -> s;
        return identityFunction;
    }
}

