/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.feed;

import eu.dnetlib.index.solr.feed.ResultTransformer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.solr.common.SolrInputDocument;

public abstract class InputDocumentFactory {
    public static final String INDEX_FIELD_PREFIX = "__";
    public static final String DS_VERSION = "__dsversion";
    public static final String DS_ID = "__dsid";
    public static final String RESULT = "result";
    public static final String INDEX_RESULT = "__result";
    public static final String INDEX_RECORD_ID = "__indexrecordidentifier";
    private static final String outFormat = new String("yyyy-MM-dd'T'hh:mm:ss'Z'");
    private static final List<String> dateFormats = Arrays.asList("yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy");

    public abstract SolrInputDocument parseDocument(String var1, String var2, String var3, String var4) throws XMLStreamException;

    public abstract SolrInputDocument parseDocument(String var1, String var2, String var3, String var4, ResultTransformer var5) throws XMLStreamException;

    public static String getParsedDateField(String date) {
        return new SimpleDateFormat(outFormat).format(InputDocumentFactory.tryParse(date));
    }

    public static Date tryParse(String date) {
        for (String formatString : dateFormats) {
            try {
                return new SimpleDateFormat(formatString).parse(date);
            }
            catch (ParseException parseException) {
            }
        }
        throw new IllegalStateException("unable to parse date: " + date);
    }

    public String parseDate(String date) {
        return InputDocumentFactory.getParsedDateField(date);
    }
}

