/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.utils;

import eu.dnetlib.rmi.provision.IndexServiceException;
import java.io.IOException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.io.Resource;

public class IndexSchemaFactory {
    private static final Log log = LogFactory.getLog(IndexSchemaFactory.class);
    private static final String TEXT_FIELD_TYPE = "textFieldType";
    private Resource schemaTemplate;
    private String textFieldType;
    private Transformer transformer;

    public void init() throws TransformerConfigurationException, TransformerFactoryConfigurationError, DocumentException, IOException {
        this.transformer = TransformerFactory.newInstance().newTransformer((Source)new DocumentSource(new SAXReader().read(this.getSchemaTemplate().getInputStream())));
        this.transformer.setParameter(TEXT_FIELD_TYPE, this.getTextFieldType());
    }

    public String getSchema(Document fields) throws IndexServiceException {
        log.debug((Object)("default field type: " + this.getTextFieldType()));
        log.debug((Object)("building schema from fields: \n" + fields.asXML() + "\n"));
        DocumentResult result = new DocumentResult();
        try {
            this.transformer.transform((Source)new DocumentSource(fields), (Result)result);
            String xml = result.getDocument().asXML();
            log.debug((Object)("new index schema:\n" + xml));
            return xml;
        }
        catch (TransformerException e) {
            throw new IndexServiceException((Throwable)e);
        }
    }

    @Required
    public void setSchemaTemplate(Resource schemaTemplate) {
        this.schemaTemplate = schemaTemplate;
    }

    public Resource getSchemaTemplate() {
        return this.schemaTemplate;
    }

    @Required
    public void setTextFieldType(String textFieldType) {
        this.textFieldType = textFieldType;
    }

    public String getTextFieldType() {
        return this.textFieldType;
    }
}

