/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.feed;

import eu.dnetlib.clients.index.model.document.IndexDocument;
import eu.dnetlib.index.IndexCollection;
import eu.dnetlib.index.feed.FeedResult;
import eu.dnetlib.rmi.provision.IndexServiceException;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DocumentFeeder
implements Callable<FeedResult> {
    private static final Log log = LogFactory.getLog(DocumentFeeder.class);
    private IndexCollection indexCollection;
    private Stream<IndexDocument> docStream;

    public DocumentFeeder(IndexCollection indexCollection, Stream<IndexDocument> docStream) {
        this.indexCollection = indexCollection;
        this.docStream = docStream;
    }

    @Override
    public FeedResult call() {
        FeedResult res = new FeedResult(System.currentTimeMillis());
        this.docStream.forEach(doc -> {
            switch (doc.getStatus()) {
                case OK: {
                    boolean rsp = false;
                    try {
                        rsp = this.indexCollection.add((IndexDocument)doc);
                    }
                    catch (IndexServiceException e) {
                        log.error((Object)e);
                    }
                    if (rsp) {
                        res.add();
                        break;
                    }
                    res.mark();
                    break;
                }
                case MARKED: {
                    res.mark();
                    log.debug((Object)("skipping record: " + doc.getFieldValue("__indexrecordidentifier")));
                    break;
                }
                case ERROR: {
                    res.skip();
                    log.info((Object)("Error on record: " + doc.getFieldValue("__indexrecordidentifier")));
                    break;
                }
                default: {
                    throw new IllegalStateException("unknow document status");
                }
            }
        });
        return res;
    }
}

