/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.index.solr.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
import eu.dnetlib.clients.index.client.IndexClient;
import eu.dnetlib.clients.index.client.IndexClientException;
import eu.dnetlib.clients.index.client.response.BrowseEntry;
import eu.dnetlib.clients.index.client.response.BrowseValueEntry;
import eu.dnetlib.clients.index.client.response.LookupResponse;
import eu.dnetlib.clients.index.model.Any;
import eu.dnetlib.clients.index.query.IndexQueryFactory;
import eu.dnetlib.clients.index.query.IndexQueryResponse;
import eu.dnetlib.clients.index.query.QueryLanguage;
import eu.dnetlib.clients.index.query.QueryResponseFactory;
import eu.dnetlib.clients.index.query.QueryResponseParser;
import eu.dnetlib.cql.CqlValueTransformerMap;
import eu.dnetlib.index.query.SolrIndexQuery;
import eu.dnetlib.index.query.SolrIndexQueryFactory;
import eu.dnetlib.index.query.SolrIndexQueryResponse;
import eu.dnetlib.index.solr.cql.SolrTypeBasedCqlValueTransformerMapFactory;
import eu.dnetlib.index.solr.feed.StreamingInputDocumentFactory;
import eu.dnetlib.index.utils.ZkServers;
import eu.dnetlib.miscutils.datetime.HumanTime;
import eu.dnetlib.rmi.provision.BrowsingRow;
import eu.dnetlib.rmi.provision.GroupResult;
import eu.dnetlib.utils.MetadataReference;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.LukeResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;

public class SolrIndexClient
implements IndexClient {
    private static final Log log = LogFactory.getLog(SolrIndexClient.class);
    private static final String INDEX_RECORD_RESULT_FIELD = "dnetResult";
    private static String ZK_ADDRESS = "address";
    private String format;
    private String layout;
    private String interpretation;
    protected Map<String, String> serviceProperties;
    private CloudSolrClient client;
    private SolrIndexQueryFactory solrIndexQueryFactory;
    private QueryResponseFactory<QueryResponse> queryResponseFactory;
    private SolrTypeBasedCqlValueTransformerMapFactory tMapFactory;

    public SolrIndexClient(String format, String layout, String interpretation, Map<String, String> serviceProperties, SolrIndexQueryFactory indexQueryFactory, QueryResponseFactory<QueryResponse> queryResponseFactory, SolrTypeBasedCqlValueTransformerMapFactory tMapFactory) {
        this.format = format;
        this.layout = layout;
        this.interpretation = interpretation;
        this.serviceProperties = serviceProperties;
        this.solrIndexQueryFactory = indexQueryFactory;
        this.queryResponseFactory = queryResponseFactory;
        this.tMapFactory = tMapFactory;
        log.debug((Object)String.format("Created a new instance of the index of type %s-%s-%s", format, layout, interpretation));
    }

    public long delete(String query) throws IndexClientException {
        try {
            log.debug((Object)("delete by query: " + query));
            MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
            SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
            String tquery = translatedQuery.getQuery();
            translatedQuery.setQueryLimit(0);
            SolrIndexQueryResponse rsp = new SolrIndexQueryResponse(this.getClient().query((SolrParams)translatedQuery));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)rsp, mdRef);
            long total = responseParser.getNumFound();
            this.getClient().deleteByQuery(tquery);
            this.getClient().commit();
            return total;
        }
        catch (Exception e) {
            throw new IndexClientException("unable to run delete by query: " + query, (Throwable)e);
        }
    }

    public List<BrowseEntry> browse(String query, List<String> browseFields, int max) throws IndexClientException {
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = this.buildBrowseQuery(query, browseFields, max, mdRef);
        return this.executeBrowseQuery(query, translatedQuery, mdRef, browseFields);
    }

    public List<BrowseEntry> browse(String query, List<String> browseFields, int max, List<String> filterQuery) throws IndexClientException {
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = this.buildBrowseQuery(query, browseFields, max, mdRef);
        if (filterQuery != null) {
            log.debug((Object)"Filter Query:");
            for (String fq : filterQuery) {
                translatedQuery.addFilterQuery(new String[]{fq});
                log.debug((Object)("- " + fq));
            }
        }
        return this.executeBrowseQuery(query, translatedQuery, mdRef, browseFields);
    }

    private SolrIndexQuery buildBrowseQuery(String query, List<String> browseFields, int max, MetadataReference mdRef) throws IndexClientException {
        log.debug((Object)("Browse request for the index collection for query:" + query));
        SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
        translatedQuery.setFacet(true);
        if (browseFields != null) {
            List browsableFields = this.solrIndexQueryFactory.getBrowsableFields(browseFields, mdRef);
            log.debug((Object)"Browsing fields:");
            for (String field : browsableFields) {
                translatedQuery.addFacetField(new String[]{field});
                log.debug((Object)("- " + field));
            }
            translatedQuery.setFacetLimit(max);
            log.debug((Object)("max number of browsing field :" + max));
        }
        return translatedQuery;
    }

    private List<BrowseEntry> executeBrowseQuery(String originalQuery, SolrIndexQuery query, MetadataReference mdRef, List<String> browseFields) throws IndexClientException {
        try {
            SolrIndexQueryResponse response = new SolrIndexQueryResponse(this.getClient().query((SolrParams)query));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)response, mdRef);
            List results = responseParser.getBrowsingResults();
            List<BrowseEntry> out = this.convertBrowseEntry(browseFields, results, (BiMap<String, String>)responseParser.getAliases());
            return out;
        }
        catch (IOException | SolrServerException e) {
            throw new IndexClientException("Error on executing a query " + originalQuery, e);
        }
    }

    private String getUrl() throws IndexClientException {
        String address = this.serviceProperties.get(ZK_ADDRESS);
        if (StringUtils.isBlank((CharSequence)address)) {
            throw new IndexClientException("Unable to load a solr client, missing zk address");
        }
        return address;
    }

    public SolrClient getClient() throws IndexClientException {
        if (this.client == null) {
            String url = this.getUrl();
            log.debug((Object)("create new Client " + url));
            ZkServers zk = ZkServers.newInstance(url);
            this.client = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).build();
            this.client.connect();
            this.client.setDefaultCollection(String.format("%s-%s-%s", this.getFormat(), this.getLayout(), this.getInterpretation()));
            try {
                this.client.ping();
            }
            catch (Exception e) {
                throw new IndexClientException("oops something went wrong", (Throwable)e);
            }
        }
        return this.client;
    }

    public void setClient(CloudSolrClient client) {
        this.client = client;
    }

    public LookupResponse lookup(String query, List<String> filterQuery, int from, int to) throws IndexClientException {
        log.debug((Object)("lookup request for the index collection for query:" + query));
        MetadataReference mdRef = new MetadataReference(this.getFormat(), this.getLayout(), this.getInterpretation());
        SolrIndexQuery translatedQuery = (SolrIndexQuery)this.solrIndexQueryFactory.getIndexQuery(QueryLanguage.CQL, query, this, mdRef);
        translatedQuery.setQueryOffset(from);
        translatedQuery.setQueryLimit(to - from + 1);
        if (filterQuery != null) {
            for (String fq : filterQuery) {
                translatedQuery.addFilterQuery(new String[]{fq});
            }
        }
        try {
            SolrIndexQueryResponse response = new SolrIndexQueryResponse(this.getClient().query((SolrParams)translatedQuery));
            QueryResponseParser responseParser = this.queryResponseFactory.getQueryResponseParser((IndexQueryResponse)response, mdRef);
            return new LookupResponse(responseParser);
        }
        catch (IOException | SolrServerException e) {
            throw new IndexClientException("Error on executing a query " + query, e);
        }
    }

    public CqlValueTransformerMap getCqlValueTransformerMap(MetadataReference mdRef) throws IndexClientException {
        try {
            return this.tMapFactory.getIt(this.readFieldNamesAndTypes());
        }
        catch (Exception e) {
            throw new IndexClientException((Throwable)e);
        }
    }

    public IndexQueryFactory getIndexQueryFactory() {
        return this.solrIndexQueryFactory;
    }

    public void close() throws IOException {
        log.debug((Object)("shutdown client: " + this.serviceProperties.get(ZK_ADDRESS)));
        this.client.close();
    }

    public int feed(String record, String indexDsId, Function<String, String> toIndexRecord) throws IndexClientException {
        return this.feed(record, indexDsId, toIndexRecord, true);
    }

    public int feed(String record, String indexDsId, Function<String, String> toIndexRecord, boolean commit) throws IndexClientException {
        try {
            SolrInputDocument doc = this.prepareSolrDocument(record, indexDsId, toIndexRecord);
            if (doc == null || doc.isEmpty()) {
                throw new IndexClientException("Invalid solr document");
            }
            return this.feed(doc, commit);
        }
        catch (Throwable e) {
            throw new IndexClientException("Error feeding document", e);
        }
    }

    public int feed(SolrInputDocument document) throws IndexClientException {
        return this.feed(document, true);
    }

    public int feed(List<SolrInputDocument> document) throws IndexClientException {
        try {
            UpdateResponse res = this.getClient().add(document);
            log.debug((Object)("feed time for single records, elapsed time: " + HumanTime.exactly((long)res.getElapsedTime())));
            if (res.getStatus() != 0) {
                throw new IndexClientException("bad status: " + res.getStatus());
            }
            return res.getStatus();
        }
        catch (Throwable e) {
            throw new IndexClientException("Error feeding document", e);
        }
    }

    public int feed(SolrInputDocument document, boolean commit) throws IndexClientException {
        try {
            UpdateResponse res = this.getClient().add(document);
            log.debug((Object)("feed time for single records, elapsed time: " + HumanTime.exactly((long)res.getElapsedTime())));
            if (res.getStatus() != 0) {
                throw new IndexClientException("bad status: " + res.getStatus());
            }
            if (commit) {
                this.getClient().commit();
            }
            return res.getStatus();
        }
        catch (Throwable e) {
            throw new IndexClientException("Error feeding document", e);
        }
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback) throws IndexClientException {
        this.feed(docs, callback, true);
    }

    public void feed(List<SolrInputDocument> docs, AfterFeedingCallback callback, boolean commit) throws IndexClientException {
        try {
            if (docs.isEmpty()) {
                log.debug((Object)"Empty list of documents. Calling callback, if needed.");
                if (callback != null) {
                    callback.doAfterFeeding(null);
                }
                return;
            }
            UpdateResponse res = this.getClient().add(docs);
            log.debug((Object)("feed time for " + docs.size() + " records, elapsed tipe: : " + HumanTime.exactly((long)res.getElapsedTime())));
            if (commit) {
                this.getClient().commit();
            }
            if (callback != null) {
                callback.doAfterFeeding(res);
            }
            if (res.getStatus() != 0) {
                throw new IndexClientException("bad status: " + res.getStatus());
            }
        }
        catch (Throwable e) {
            throw new IndexClientException("Error feeding documents", e);
        }
    }

    public SolrInputDocument prepareSolrDocument(String record, String indexDsId, Function<String, String> toIndexRecord) throws IndexClientException {
        try {
            StreamingInputDocumentFactory documentFactory = new StreamingInputDocumentFactory();
            String version = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss'Z'").format(new Date());
            String indexRecord = toIndexRecord.apply(record);
            if (log.isDebugEnabled()) {
                log.debug((Object)("***************************************\nSubmitting index record:\n" + indexRecord + "\n***************************************\n"));
            }
            return documentFactory.parseDocument(version, indexRecord, indexDsId, INDEX_RECORD_RESULT_FIELD);
        }
        catch (Throwable e) {
            throw new IndexClientException("Error creating solr document", e);
        }
    }

    public boolean isRecordIndexed(String id) throws IndexClientException {
        QueryResponse res = this.query("objidentifier:\"" + id + "\"", null);
        return res.getResults().size() > 0;
    }

    public int remove(String id) throws IndexClientException {
        return this.remove(id, true);
    }

    public UpdateResponse commit() throws IndexClientException {
        try {
            return this.getClient().commit();
        }
        catch (IOException | SolrServerException e) {
            throw new IndexClientException(e);
        }
    }

    public int remove(String id, boolean commit) throws IndexClientException {
        try {
            UpdateResponse res = this.getClient().deleteByQuery("objidentifier:\"" + id + "\"");
            if (commit) {
                this.getClient().commit();
            }
            return res.getResponse().size();
        }
        catch (Throwable e) {
            throw new IndexClientException("Error removing documents", e);
        }
    }

    public int count(String query) throws IndexClientException {
        QueryResponse res = this.query(query, 0);
        return res.getResults().size();
    }

    public QueryResponse query(String query, Integer rows) throws IndexClientException {
        try {
            SolrQuery solrQuery = new SolrQuery();
            solrQuery.setQuery(query);
            if (rows != null && rows >= 0) {
                solrQuery.setRows(rows);
            }
            return this.getClient().query((SolrParams)solrQuery);
        }
        catch (Throwable e) {
            throw new IndexClientException("Error searching documents", e);
        }
    }

    public UpdateResponse deleteByQuery(String query) throws IndexClientException {
        try {
            return this.getClient().deleteByQuery(query);
        }
        catch (Throwable e) {
            throw new IndexClientException("Error searching documents", e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public Map<String, String> getServiceProperties() {
        return this.serviceProperties;
    }

    public void setServiceProperties(Map<String, String> serviceProperties) {
        this.serviceProperties = serviceProperties;
    }

    private List<BrowseEntry> convertBrowseEntry(List<String> browseFields, List<BrowsingRow> results, BiMap<String, String> aliases) {
        HashMap<String, BrowseEntry> mapResult = new HashMap<String, BrowseEntry>();
        for (BrowsingRow row : results) {
            for (GroupResult groupResult : row.getGroupResult()) {
                ArrayList<BrowseValueEntry> valuesEntry;
                BrowseEntry entry;
                String name = groupResult.getName();
                if (mapResult.containsKey(name)) {
                    entry = (BrowseEntry)mapResult.get(name);
                    valuesEntry = entry.getValues();
                    if (valuesEntry == null) {
                        valuesEntry = new ArrayList<BrowseValueEntry>();
                        entry.setValues(valuesEntry);
                    }
                } else {
                    entry = new BrowseEntry();
                    entry.setField(name);
                    entry.setLabel(name);
                    valuesEntry = new ArrayList();
                    entry.setValues(valuesEntry);
                    mapResult.put(name, entry);
                }
                String value = groupResult.getValue();
                int count = groupResult.getCount();
                BrowseValueEntry entryValue = new BrowseValueEntry(value, count);
                valuesEntry.add(entryValue);
            }
        }
        ArrayList<BrowseEntry> out = new ArrayList<BrowseEntry>();
        for (String b : browseFields) {
            String inverse = null;
            if (aliases != null) {
                String string = inverse = aliases.get((Object)b) != null ? (String)aliases.get((Object)b) : (String)aliases.inverse().get((Object)b);
            }
            if (mapResult.containsKey(b)) {
                out.add((BrowseEntry)mapResult.get(b));
                continue;
            }
            if (!mapResult.containsKey(inverse)) continue;
            BrowseEntry data = (BrowseEntry)mapResult.get(inverse);
            data.setField(b);
            out.add(data);
        }
        return out;
    }

    private Map<String, Any.ValueType> readFieldNamesAndTypes() throws SolrServerException, IOException, IndexClientException {
        LukeRequest request = new LukeRequest();
        request.setShowSchema(true);
        request.setNumTerms(0);
        LukeResponse response = (LukeResponse)request.process(this.getClient());
        Map fieldInfos = response.getFieldInfo();
        Map fieldTypeInfos = response.getFieldTypeInfo();
        HashMap result = Maps.newHashMap();
        for (LukeResponse.FieldInfo fieldInfo : fieldInfos.values()) {
            LukeResponse.FieldTypeInfo fieldTypeInfo = (LukeResponse.FieldTypeInfo)fieldTypeInfos.get(fieldInfo.getType());
            String fieldName = fieldTypeInfo.getName().toLowerCase();
            Any.ValueType fieldType = this.resolveSolrTypeClassName(fieldName);
            result.put(fieldInfo.getName(), fieldType);
        }
        return result;
    }

    private Any.ValueType resolveSolrTypeClassName(String solrTypeName) {
        if (solrTypeName.contains("LongField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("IntField")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("short")) {
            return Any.ValueType.LONG;
        }
        if (solrTypeName.contains("float")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("double")) {
            return Any.ValueType.DOUBLE;
        }
        if (solrTypeName.contains("date")) {
            return Any.ValueType.DATETIME;
        }
        return Any.ValueType.STRING;
    }

    public static interface AfterFeedingCallback {
        public void doAfterFeeding(UpdateResponse var1);
    }
}

