package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction extends AbstractMDStoreAction {

	private static final Log log = LogFactory.getLog(FeedAction.class);

	private MDStoreFeeder feeder;

	@Override
	public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws MDStoreServiceException {

		final String mdId = job.getParameters().get("mdId");
		if ((mdId == null) || mdId.isEmpty()) throw new MDStoreServiceException("Blackboard param (mdId) is empty");

		final String epr = job.getParameters().get("epr");
		if ((epr == null) || epr.isEmpty()) throw new MDStoreServiceException("Blackboard param (mdId) is empty");

		ResultSet<?> resultSet = ResultSet.fromJson(epr);

		String storingType = job.getParameters().get("storingType");
		if ((storingType == null) || storingType.isEmpty()) {
			storingType = "REFRESH";
		}

		feeder.feed(mdId, resultSet, storingType, params -> {
			job.getParameters().put("total", "" + params.get("size"));
			completeWithSuccess(handler, job);
		}, e -> {
			log.error("Error feeding mdstore: " + mdId, e);
			completeWithFail(handler, job, e);
		});
	}

	public MDStoreFeeder getFeeder() {
		return feeder;
	}

	@Required
	public void setFeeder(final MDStoreFeeder feeder) {
		this.feeder = feeder;
	}

}
