/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.httplist;

import eu.dnetlib.rmi.data.CollectorServiceRuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpListIterator
implements Iterator<String> {
    private final CloseableHttpClient client = HttpClients.createDefault();
    private String baseUrl;
    private String currentLine;
    private BufferedReader reader;

    public HttpListIterator(String baseUrl, String listAddress) {
        try {
            this.baseUrl = baseUrl;
            this.reader = new BufferedReader(new StringReader(this.download(listAddress)));
            this.currentLine = this.reader.readLine();
        }
        catch (Exception e) {
            throw new CollectorServiceRuntimeException("Error creating iterator", (Throwable)e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return StringUtils.isNotBlank((CharSequence)this.currentLine);
    }

    @Override
    public synchronized String next() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.currentLine)) {
                String string = this.download(this.baseUrl + this.currentLine);
                return string;
            }
            throw new CollectorServiceRuntimeException("Iterator has reached the end");
        }
        finally {
            try {
                this.currentLine = this.reader.readLine();
            }
            catch (IOException e) {
                throw new CollectorServiceRuntimeException("Error obtaining next element " + this.currentLine, (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String download(String url) {
        HttpGet method = new HttpGet(url);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)method);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode) {
                String string = IOUtils.toString((InputStream)new BufferedInputStream(response.getEntity().getContent()));
                return string;
            }
            throw new CollectorServiceRuntimeException("Error " + statusCode + " dowloading url: " + url);
        }
        catch (IOException e) {
            throw new CollectorServiceRuntimeException("Error downloading url: " + url);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

