package eu.dnetlib.data.collector.plugins.datacite;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;


public class DataciteParser {


    public static List<String> parse(final InputStream input) throws IOException {
        final String json = IOUtils.toString(input);
        final JsonElement root = new JsonParser().parse(json);
        final JsonArray data = getArrayField("data",root.getAsJsonObject());
        final List<String > result = new ArrayList<>();
        data.forEach(it -> {
            final String  xml = it.getAsJsonObject().getAsJsonObject("attributes").get("xml").getAsString();
            byte[] decoded = Base64.getMimeDecoder().decode(xml);
            result.add(new String(decoded));
        });

        return result;
    }


    public static JsonArray getArrayField(final String fieldName, final JsonObject root) {
        if (!root.has(fieldName)) {
            return  null;
        }
        return root.get(fieldName).getAsJsonArray();
    }



}
