package eu.dnetlib.data.collector.plugins.mongo;

import java.io.BufferedReader;
import java.util.Iterator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoDumpIterator implements Iterator<String> {

    private static final Log log = LogFactory.getLog(MongoDumpIterator.class);

	private final BufferedReader inputStream;
	private String currentLine = null;

    public MongoDumpIterator(final BufferedReader inputStream) {
        this.inputStream = inputStream;
        this.currentLine = getNextLine();
	}

	@Override
	public boolean hasNext() {
		return currentLine != null;

	}

	@Override
	public String next() {
		final String returnedString = this.currentLine;
		this.currentLine = getNextLine();
		return returnedString;
	}

	@Override
	public void remove() {
		// TODO Auto-generated method stub

	}

	private String getNextLine() {
        String input = null;
        try {
            input = inputStream.readLine();
            while (input != null) {
				try {
					JsonElement jElement = new JsonParser().parse(input);
					JsonObject jobject = jElement.getAsJsonObject();
					if (jobject.has("body")) {
						return jobject.get("body").getAsString();
					}
				} catch (Throwable e) {

				}
				input = inputStream.readLine();
			}
			return null;

        } catch (Exception e) {
            log.error("Error on parsing json " + input);
			log.error(e.getMessage());
			e.printStackTrace();
			return null;
		}
	}
}
