package eu.dnetlib.data.mdstore.modular.connector;

import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.rmi.data.DocumentNotFoundException;

public interface MDStore {

	String getId();

	String getFormat();

	String getInterpretation();

	String getLayout();

	void truncate();

	void feed(Iterable<String> records, boolean incremental);

	ResultSetListener<String> deliver(String from, String until, String recordFilter);

	ResultSetListener<String> deliverIds(String from, String until, String recordFilter);

	Iterable<String> iterate();

	int getSize();

	void deleteRecord(String recordId);

	String getRecord(String recordId) throws DocumentNotFoundException;

}
