/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.action.AbstractMDStoreAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction
extends AbstractMDStoreAction {
    private static final Log log = LogFactory.getLog(FeedAction.class);
    private MDStoreFeeder feeder;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws MDStoreServiceException {
        String mdId = (String)job.getParameters().get("mdId");
        if (mdId == null || mdId.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String epr = (String)job.getParameters().get("epr");
        if (epr == null || epr.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        ResultSet resultSet = ResultSet.fromJson((String)epr);
        String storingType = (String)job.getParameters().get("storingType");
        if (storingType == null || storingType.isEmpty()) {
            storingType = "REFRESH";
        }
        this.feeder.feed(mdId, resultSet, storingType, params -> {
            job.getParameters().put("total", "" + (String)params.get("size"));
            this.completeWithSuccess(handler, job);
        }, (e, params) -> {
            log.error((Object)("Error feeding mdstore: " + mdId), e);
            this.completeWithFail(handler, job, e);
        });
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }
}

