package eu.dnetlib.data.collector.plugins.datacite;
import eu.dnetlib.rmi.data.CollectorServiceException;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataciteApiIterator implements Iterator<String> {

    private static String baseURL = "https://api.datacite.org/works";

    private String fromDate;

    private int currentPage = 0;

    private final List<String> recordBuffer = new ArrayList<>();

    public DataciteApiIterator() {
        try {
            constructRecordBuffer();
        } catch (CollectorServiceException e) {
            e.printStackTrace();
        }
    }

    public DataciteApiIterator(final String fromDate) {
        this.fromDate = fromDate;
        try {
            constructRecordBuffer();
        } catch (CollectorServiceException e) {
            e.printStackTrace();
        }
    }


    @Override
    public boolean hasNext() {
        return !recordBuffer.isEmpty();
    }

    @Override
    public String next() {
        final String tmp = recordBuffer.remove(0);

        if (recordBuffer.size() < 10) {
            try {
                constructRecordBuffer();
            } catch (CollectorServiceException e) {
                e.printStackTrace();
            }
        }

        return tmp;
    }


    private HttpGet constructMethod() {
        String requestUrl = baseURL;
        if (fromDate != null) {
            requestUrl += "?from-update-date="+ fromDate;
            if (currentPage >0 )
                requestUrl += "&page[number]="+ currentPage;
        } else {
            if (currentPage >0 )
                requestUrl += "?page[number]="+ currentPage;
        }
        return new HttpGet(requestUrl);
    }

    private void constructRecordBuffer() throws CollectorServiceException {
        final HttpGet method = constructMethod();
        try(CloseableHttpClient client = HttpClients.createDefault()) {
            try(CloseableHttpResponse response = client.execute(method)) {
                int statusCode = response.getStatusLine().getStatusCode();

                if (HttpStatus.SC_OK != statusCode) {
                    throw new CollectorServiceException("Error " + statusCode + " dowloading url: " + method.getURI().toString());
                }

                InputStream content = response.getEntity().getContent();
                recordBuffer.addAll(DataciteParser.parse(content));
                currentPage ++;
            }
        } catch (IOException e) {
            throw new CollectorServiceException("Error dowloading url: "  + method.getURI().toString());
        }
    }

    public String getFromDate() {
        return fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public List<String> getRecordBuffer() {
        return recordBuffer;
    }
}
