/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.core.xsl.ext;

import eu.dnetlib.data.collective.transformation.engine.FunctionResults;
import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.IdentifierExtract;
import eu.dnetlib.data.collective.transformation.engine.functions.LookupRecord;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.engine.functions.RegularExpression;
import eu.dnetlib.data.collective.transformation.engine.functions.Split;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.svenson.JSONParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class TransformationFunctionProxy {
    private static final Log log = LogFactory.getLog(TransformationFunctionProxy.class);
    private static TransformationFunctionProxy tf;
    private static DocumentBuilder docBuilder;
    private static Transformer transformer;
    private static XPath xpath;
    private RegularExpression regExprFunction = new RegularExpression();
    private Convert convertFunction;
    private IdentifierExtract identifierExtractFunction = new IdentifierExtract();
    private Split split = new Split();
    private Map<String, FunctionResults> mapOfResults = new HashMap<String, FunctionResults>();
    private LookupRecord lookupRecord;

    public static TransformationFunctionProxy getInstance() {
        if (tf == null) {
            tf = new TransformationFunctionProxy();
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                docBuilder = dbf.newDocumentBuilder();
                transformer = TransformerFactory.newInstance().newTransformer();
                xpath.setNamespaceContext(new NamespaceContext(){

                    public Iterator getPrefixes(String namespaceURI) {
                        return null;
                    }

                    @Override
                    public String getPrefix(String namespaceURI) {
                        return null;
                    }

                    @Override
                    public String getNamespaceURI(String aPrefix) {
                        if (aPrefix == null) {
                            throw new IllegalArgumentException("No prefix provided!");
                        }
                        if (aPrefix.equals("")) {
                            return "http://namespace.openaire.eu";
                        }
                        if (aPrefix.equals("dc")) {
                            return "http://purl.org/dc/elements/1.1/";
                        }
                        return "";
                    }
                });
            }
            catch (Exception e) {
                log.fatal((Object)"error while instantiating DocumentBuilderFactory, Transfomer, Xpath.namespacecontext", (Throwable)e);
                throw new IllegalStateException(e);
            }
        }
        return tf;
    }

    public String getValue(String uniqueKey, int i) {
        if (!this.mapOfResults.containsKey(uniqueKey)) {
            throw new IllegalStateException("unknown key: " + uniqueKey);
        }
        return this.mapOfResults.get(uniqueKey).get(i);
    }

    public String extract(String uniqueKey, int i) {
        if (this.mapOfResults == null) {
            return "transformationFunctionProxy_extract not initialized";
        }
        if (!this.mapOfResults.containsKey(uniqueKey)) {
            throw new IllegalStateException("unknown key: " + uniqueKey);
        }
        return this.mapOfResults.get(uniqueKey).get(i);
    }

    public synchronized String convertString(String aInput, String aVocabularyName) {
        LinkedList<String> values = new LinkedList<String>();
        values.add(aInput);
        try {
            log.debug((Object)("conversion input: " + aInput));
            String conversionResult = this.convertFunction.executeSingleValue(aVocabularyName, values);
            log.debug((Object)("conversion result: " + conversionResult));
            return conversionResult;
        }
        catch (ProcessingException e) {
            log.fatal((Object)("convert failed for args 'input': " + aInput + " , 'vocabularyName': " + aVocabularyName), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public synchronized String convert(NodeList aInput, String aVocabularyName) {
        LinkedList<String> values = new LinkedList<String>();
        this.getTextFromNodeList(aInput, values);
        try {
            return this.convertFunction.executeSingleValue(aVocabularyName, values);
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized String convert(NodeList aInput, String aVocabularyName, String aDefaultPattern, String aFunction) {
        LinkedList<String> values = new LinkedList<String>();
        this.getTextFromNodeList(aInput, values);
        try {
            List<String> results = this.convertFunction.executeFilterByParams(aVocabularyName, values, aDefaultPattern, aFunction);
            if (results.size() > 0) {
                return results.get(0);
            }
            return "";
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    private void getTextFromNodeList(NodeList aNodeList, List<String> aTextvalues) {
        for (int i = 0; i < aNodeList.getLength(); ++i) {
            Node n = aNodeList.item(i);
            if (n.getNodeType() == 1) {
                this.getTextFromNodeList(n.getChildNodes(), aTextvalues);
                continue;
            }
            if (!(n instanceof Text)) continue;
            aTextvalues.add(n.getNodeValue());
        }
    }

    public synchronized String regExpr(String aInput, String aReplacement, String aRegularExpression) {
        try {
            int lastSlash = aRegularExpression.lastIndexOf("/");
            String trailingOptions = aRegularExpression.substring(lastSlash);
            int replacementSlash = aRegularExpression.substring(0, lastSlash).lastIndexOf("/");
            String replacementFromExpression = aRegularExpression.substring(replacementSlash + 1, lastSlash);
            String newRegExpr = aRegularExpression.substring(0, replacementSlash + 1) + aReplacement + replacementFromExpression + trailingOptions;
            return this.regExprFunction.executeSingleValue(newRegExpr, aInput, aReplacement);
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public String lookup(String aIdentifier, String aPropertyKey) {
        log.debug((Object)("functionProxy.lookup: param identifier: " + aIdentifier + " , key: " + aPropertyKey));
        return this.lookupRecord.getPropertyValue(aIdentifier, aPropertyKey);
    }

    public synchronized Collection<String> split(NodeList aInput, String aRegularExpression, String aCallId) {
        try {
            LinkedList<String> textValues = new LinkedList<String>();
            this.getTextFromNodeList(aInput, textValues);
            return this.split.executeAllValues(textValues, aRegularExpression);
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized String split(String aCallId) {
        try {
            return this.split.executeSingleValue(aCallId);
        }
        catch (ProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized NodeList identifierExtract(String aXpathExprJson, Node aInput, String aRegExpression) {
        String xpathExprJson = StringEscapeUtils.unescapeXml((String)aXpathExprJson);
        log.debug((Object)("unescape xpathExprJson: " + xpathExprJson));
        String regExpression = StringEscapeUtils.unescapeXml((String)aRegExpression);
        log.debug((Object)("unescape regExpr" + regExpression));
        try {
            List xpathExprList = (List)JSONParser.defaultJSONParser().parse(List.class, xpathExprJson);
            DOMSource s = new DOMSource(aInput);
            StringWriter w = new StringWriter();
            StreamResult r = new StreamResult(w);
            transformer.transform(s, r);
            Document doc = docBuilder.parse(new InputSource(new StringReader(w.toString())));
            return this.identifierExtractFunction.extract(xpathExprList, doc, regExpression, docBuilder.newDocument(), xpath);
        }
        catch (Exception e) {
            log.fatal((Object)("identifierExtract failed for node value: " + aInput.getNodeValue()), (Throwable)e);
            throw new IllegalStateException(e.getMessage());
        }
    }

    public void setResults(String key, FunctionResults resultsFunction_getvalue) {
        this.mapOfResults.put(key, resultsFunction_getvalue);
    }

    public Convert getConvertFunction() {
        return this.convertFunction;
    }

    public void setConvertFunction(Convert convertFunction) {
        this.convertFunction = convertFunction;
    }

    public LookupRecord getLookupRecord() {
        return this.lookupRecord;
    }

    public void setLookupRecord(LookupRecord lookupRecord) {
        this.lookupRecord = lookupRecord;
    }

    static {
        xpath = XPathFactory.newInstance().newXPath();
    }
}

