/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datacite;

import eu.dnetlib.data.collector.plugins.datacite.DataciteParser;
import eu.dnetlib.rmi.data.CollectorServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class DataciteApiIterator
implements Iterator<String> {
    private static String baseURL = "https://api.datacite.org/works";
    private String fromDate;
    private int currentPage = 0;
    private final List<String> recordBuffer = new ArrayList<String>();

    public DataciteApiIterator() {
        try {
            this.constructRecordBuffer();
        }
        catch (CollectorServiceException e) {
            e.printStackTrace();
        }
    }

    public DataciteApiIterator(String fromDate) {
        this.fromDate = fromDate;
        try {
            this.constructRecordBuffer();
        }
        catch (CollectorServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasNext() {
        return !this.recordBuffer.isEmpty();
    }

    @Override
    public String next() {
        String tmp = this.recordBuffer.remove(0);
        if (this.recordBuffer.size() < 10) {
            try {
                this.constructRecordBuffer();
            }
            catch (CollectorServiceException e) {
                e.printStackTrace();
            }
        }
        return tmp;
    }

    private HttpGet constructMethod() {
        String requestUrl = baseURL;
        if (this.fromDate != null) {
            requestUrl = requestUrl + "?from-update-date=" + this.fromDate;
            if (this.currentPage > 0) {
                requestUrl = requestUrl + "&page[number]=" + this.currentPage;
            }
        } else if (this.currentPage > 0) {
            requestUrl = requestUrl + "?page[number]=" + this.currentPage;
        }
        return new HttpGet(requestUrl);
    }

    private void constructRecordBuffer() throws CollectorServiceException {
        HttpGet method = this.constructMethod();
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)method);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 != statusCode) {
                throw new CollectorServiceException("Error " + statusCode + " dowloading url: " + method.getURI().toString());
            }
            InputStream content = response.getEntity().getContent();
            this.recordBuffer.addAll(DataciteParser.parse(content));
            ++this.currentPage;
        }
        catch (IOException e) {
            throw new CollectorServiceException("Error dowloading url: " + method.getURI().toString());
        }
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public List<String> getRecordBuffer() {
        return this.recordBuffer;
    }
}

