/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import eu.dnetlib.data.mdstore.modular.RecordParser;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class MongoBulkWritesManager {
    private static final Log log = LogFactory.getLog(MongoBulkWritesManager.class);
    private final boolean discardRecords;
    private RecordParser recordParser;
    private MongoCollection<DBObject> validCollection;
    private List<WriteModel<DBObject>> validBulkOperationList;
    private int validOpCounter;
    private BulkWriteOptions writeOptions;
    private MongoCollection<DBObject> discardedCollection;
    private List<WriteModel<DBObject>> discardedBulkOperationList;
    private int discardedOpCounter;
    private int bulkSize;

    public MongoBulkWritesManager(MongoCollection<DBObject> collection, MongoCollection<DBObject> discardedCollection, int bulkSize, RecordParser parser, boolean discardRecords) {
        this.validCollection = collection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.validBulkOperationList = Lists.newArrayList();
        this.validOpCounter = 0;
        this.discardedCollection = discardedCollection.withWriteConcern(WriteConcern.ACKNOWLEDGED);
        this.discardedBulkOperationList = Lists.newArrayList();
        this.discardedOpCounter = 0;
        this.bulkSize = bulkSize;
        this.recordParser = parser;
        this.discardRecords = discardRecords;
        this.writeOptions = new BulkWriteOptions().ordered(false);
    }

    public void insert(String record) {
        block7: {
            try {
                Map<String, String> recordProperties = this.recordParser.parseRecord(record);
                log.debug((Object)("found props: " + recordProperties));
                if (recordProperties.containsKey("id")) {
                    DBObject obj = this.buildDBObject(record, recordProperties);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Saving object" + obj));
                    }
                    this.validBulkOperationList.add((WriteModel<DBObject>)new ReplaceOneModel((Bson)new BasicDBObject("id", obj.get("id")), (Object)obj, new UpdateOptions().upsert(true)));
                    ++this.validOpCounter;
                    if (this.validOpCounter % this.bulkSize == 0 && this.validOpCounter != 0) {
                        this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
                        this.validBulkOperationList = Lists.newArrayList();
                    }
                } else if (this.discardRecords) {
                    log.debug((Object)"parsed record seems invalid");
                    this.discardRecord(record);
                }
            }
            catch (Throwable e) {
                if (!this.discardRecords) break block7;
                log.debug((Object)("unhandled exception: " + e.getMessage()));
                this.discardRecord(record);
            }
        }
    }

    private void discardRecord(String record) {
        this.discardedBulkOperationList.add((WriteModel<DBObject>)new InsertOneModel((Object)new BasicDBObject("body", (Object)record)));
        ++this.discardedOpCounter;
        if (this.discardedOpCounter % this.bulkSize == 0 && this.discardedOpCounter != 0) {
            this.discardedCollection.bulkWrite(this.discardedBulkOperationList, this.writeOptions);
            this.discardedBulkOperationList = Lists.newArrayList();
        }
    }

    public void flushBulks(MongoDatabase mongoDatabase) {
        if (this.validOpCounter != 0) {
            this.validCollection = this.getCollectionWithWriteConcern(this.validCollection, WriteConcern.JOURNALED);
            this.validCollection.bulkWrite(this.validBulkOperationList, this.writeOptions);
        }
        if (this.discardedOpCounter != 0) {
            this.discardedCollection = this.getCollectionWithWriteConcern(this.discardedCollection, WriteConcern.JOURNALED);
            this.discardedCollection.bulkWrite(this.discardedBulkOperationList, this.writeOptions);
        }
        this.validCollection = this.getCollectionWithWriteConcern(this.validCollection, WriteConcern.ACKNOWLEDGED);
        this.discardedCollection = this.getCollectionWithWriteConcern(this.discardedCollection, WriteConcern.ACKNOWLEDGED);
    }

    private DBObject buildDBObject(String record, Map<String, String> recordProperties) {
        BasicDBObject obj = new BasicDBObject();
        obj.put("id", (Object)recordProperties.get("id"));
        obj.put("originalId", (Object)recordProperties.get("originalId"));
        obj.put("body", (Object)record);
        obj.put("timestamp", (Object)System.currentTimeMillis());
        return obj;
    }

    private MongoCollection<DBObject> getCollectionWithWriteConcern(MongoCollection<DBObject> collection, WriteConcern writeConcern) {
        return collection.withWriteConcern(writeConcern);
    }
}

