package eu.dnetlib.data.collector.plugins;

import java.io.BufferedInputStream;

import eu.dnetlib.miscutils.iterators.xml.XMLIterator;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSplittedRecordPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String element = interfaceDescriptor.getParams().get("splitOnElement");

		if (StringUtils.isBlank(baseUrl)) { throw new CollectorServiceException("Param 'baseurl' is null or empty"); }

		if (StringUtils.isBlank(element)) { throw new CollectorServiceException("Param 'splitOnElement' is null or empty"); }

		final BufferedInputStream bis = getBufferedInputStream(baseUrl);

		return () -> new XMLIterator(element, bis);
	}

	abstract protected BufferedInputStream getBufferedInputStream(final String baseUrl) throws CollectorServiceException;

}
