package eu.dnetlib.data.mdstore.modular;

import java.util.List;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ModularMDStoreService extends AbstractBaseService implements MDStoreService {

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler;

	private MDStoreFeeder feeder;

	private MDStoreRetriever retriever;

	@Autowired
	private ResultSetFactory resultSetFactory;

	@Override
	public ResultSet<String> deliverMDRecords(final String mdId, final String from, final String until, final String recordFilter)
			throws MDStoreServiceException {
		return retriever.deliver(mdId, from, until, recordFilter);
	}

	@Override
	public ResultSet<String> bulkDeliverMDRecords(final String format, final String layout, final String interpretation) throws MDStoreServiceException {
		return resultSetFactory.createResultSet(retriever.deliver(format, layout, interpretation));
	}

	@Override
	public String deliverRecord(final String mdId, final String recordId) throws MDStoreServiceException {
		return retriever.deliverRecord(mdId, recordId);
	}

	@Override
	public List<String> getListOfMDStores() throws MDStoreServiceException {
		return (Lists.transform(retriever.getDao().listMDStores(), input -> input.getId()));
	}

	@Override
	public List<String> listMDStores(final String format, final String layout, final String interpretation) throws MDStoreServiceException {
		return retriever.getDao().listMDStores(format, layout, interpretation);
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	@Override
	public boolean storeMDRecordsFromRS(final String mdId, final String rsId, final String storingType) throws MDStoreServiceException {
		throw new MDStoreServiceException("not implemented, use the Blackboard asynchronous equivalent");
	}

	@Override
	public int size(final String mdId) throws MDStoreServiceException {
		return this.getRetriever().getDao().getCachedSize(mdId);
	}

	@Override
	public int size(final String format, final String layout, final String interpretation) throws MDStoreServiceException {
		return this.getRetriever().getDao().getSumOfSizes(format, layout, interpretation);
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	public MDStoreFeeder getFeeder() {
		return feeder;
	}

	public void setFeeder(final MDStoreFeeder feeder) {
		this.feeder = feeder;
	}

	public MDStoreRetriever getRetriever() {
		return retriever;
	}

	public void setRetriever(final MDStoreRetriever retriever) {
		this.retriever = retriever;
	}

}
