package eu.dnetlib.data.mdstore.modular.action;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.data.MDStoreServiceException;

class StatusThread extends Thread {

	boolean shouldUpdate = false;
	final BlackboardServerHandler handler;
	final BlackboardJob job;
	final long timeout;
	final MDStorePlugin currentPlugin;

	public StatusThread(final BlackboardServerHandler handler, final BlackboardJob job, final long timeout, final MDStorePlugin currentPlugin) {
		this.job = job;
		this.handler = handler;
		this.timeout = timeout;
		this.currentPlugin = currentPlugin;
	}

	@Override
	public void run() {
		while (shouldUpdate) {
			job.getParameters().put("ongoingPercentage", currentPlugin.getStatus());
			handler.ongoing(job);
			try {
				sleep(timeout);
			} catch (final InterruptedException e) {

			}
		}
	}

	public boolean isShouldUpdate() {
		return shouldUpdate;
	}

	public void setShouldUpdate(final boolean shouldUpdate) {
		this.shouldUpdate = shouldUpdate;
	}
}

public class PluginAction extends AbstractMDStoreAction {

	private static final Log log = LogFactory.getLog(PluginAction.class);

	@Autowired
	private MDStorePluginEnumerator pluginEnumerator;

	@Override
	protected void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws MDStoreServiceException {

		final String name = job.getParameters().get("plugin.name");

		final Map<String, MDStorePlugin> plugins = pluginEnumerator.getAll();

		if ((plugins == null) || plugins.isEmpty() || !plugins.containsKey(name)) { throw new MDStoreServiceException("Unable to find plugin: " + name); }

		log.info("running MDStore plugin: " + name);

		final StatusThread st = new StatusThread(handler, job, 20000, plugins.get(name));
		st.setShouldUpdate(true);
		st.start();
		plugins.get(name).run(getDao(), job.getParameters(), params -> {
			st.setShouldUpdate(false);
			job.getParameters().putAll(params);
			handler.done(job);
		}, (e, params) -> {
			st.setShouldUpdate(false);
			job.getParameters().putAll(params);
			handler.failed(job, e);
		});
	}

}
