/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collective.transformation.engine;

import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.IDatabaseConnector;
import eu.dnetlib.data.collective.transformation.TransformationException;
import eu.dnetlib.data.collective.transformation.VocabularyRegistry;
import eu.dnetlib.data.collective.transformation.core.xsl.ext.TransformationFunctionProxy;
import eu.dnetlib.data.collective.transformation.engine.PreProcessor;
import eu.dnetlib.data.collective.transformation.engine.core.ITransformation;
import eu.dnetlib.data.collective.transformation.engine.functions.Convert;
import eu.dnetlib.data.collective.transformation.engine.functions.Extract;
import eu.dnetlib.data.collective.transformation.engine.functions.IFeatureExtraction;
import eu.dnetlib.data.collective.transformation.engine.functions.ProcessingException;
import eu.dnetlib.data.collective.transformation.engine.functions.RegularExpression;
import eu.dnetlib.data.collective.transformation.engine.functions.RetrieveValue;
import eu.dnetlib.data.collective.transformation.rulelanguage.Argument;
import eu.dnetlib.data.collective.transformation.rulelanguage.util.FunctionCall;
import eu.dnetlib.data.collective.transformation.utils.BlacklistConsumer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.instruct.TerminationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class SimpleTransformationEngine {
    private static Log log = LogFactory.getLog(SimpleTransformationEngine.class);
    private final List<String> mdRecords = new LinkedList<String>();
    private ITransformation transformation;
    private VocabularyRegistry vocabularyRegistry;
    private IDatabaseConnector databaseConnector;
    private ResourceDao resourceDao;
    private IFeatureExtraction featureExtraction;
    private long totalTransformedRecords = 0L;
    private long totalIgnoredRecords = 0L;
    private String mappingFile;
    private boolean stylesheetParamsCalculated = false;
    private boolean preprocessingDone = false;
    private Map<String, String> stylesheetParams = new LinkedHashMap<String, String>();
    private Resource blacklistApi;
    private List<String> blacklistedRecords = new LinkedList<String>();

    public void preprocess(String dataSourceId) {
        for (Map<String, String> preprocMap : this.transformation.getRuleLanguageParser().getPreprocessings()) {
            for (String function : preprocMap.keySet()) {
                if (!function.equals("blacklist")) continue;
                BlacklistConsumer bc = new BlacklistConsumer();
                try {
                    this.blacklistedRecords = bc.getBlackList(this.blacklistApi.getURL() + dataSourceId);
                }
                catch (Exception e) {
                    throw new IllegalStateException("error in preprocess: " + e.getMessage());
                }
            }
        }
        log.debug((Object)"preprocessing done.");
    }

    private boolean isBlacklistRecord(String aRecord) {
        if (this.blacklistedRecords.size() == 0) {
            return false;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            Node root = (Node)xpath.evaluate("/", new InputSource(new StringReader(aRecord)), XPathConstants.NODE);
            String objId = xpath.evaluate("//*[local-name()='objIdentifier']", root);
            if (this.blacklistedRecords.contains(objId)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("error in isBlacklistRecord: " + e.getMessage());
        }
        return false;
    }

    public String transform(String sourceRecord) {
        LinkedList<String> objectRecords = new LinkedList<String>();
        objectRecords.add(sourceRecord);
        int index = 0;
        this.mdRecords.clear();
        this.initTransformationFunction();
        if (!this.stylesheetParamsCalculated) {
            try {
                this.calculateStylesheetParams(sourceRecord);
            }
            catch (Exception e) {
                throw new IllegalStateException("error in calculateStylesheetParams" + e.getMessage());
            }
        }
        if (!this.preprocessingDone) {
            this.preprocess(this.stylesheetParams.get("varBlacklistDataSourceId"));
            this.preprocessingDone = true;
        }
        if (this.isBlacklistRecord(sourceRecord)) {
            try {
                this.mdRecords.add(this.transformation.transformRecord(sourceRecord, "syntaxcheckfailed.xsl"));
            }
            catch (Exception e) {
                log.fatal((Object)sourceRecord);
                throw new IllegalStateException(e);
            }
        }
        if (!this.transformation.getRuleLanguageParser().isXslStylesheet()) {
            log.debug((Object)("functionCalls size: " + this.transformation.getRuleLanguageParser().getFunctionCalls().size()));
            for (FunctionCall functionCall : this.transformation.getRuleLanguageParser().getFunctionCalls()) {
                this.preprocess(objectRecords, functionCall);
            }
            for (String record : objectRecords) {
                try {
                    log.debug((Object)("now run transformation for record with index: " + index));
                    try {
                        String transformedRecord = this.transformation.transformRecord(record, index);
                        this.mdRecords.add(transformedRecord);
                    }
                    catch (TerminationException e) {
                        log.debug((Object)"record transformation terminated.");
                        String failedRecord = this.transformation.transformRecord(record, "syntaxcheckfailed.xsl");
                        log.debug((Object)failedRecord);
                        ++this.totalIgnoredRecords;
                        this.mdRecords.add(failedRecord);
                    }
                }
                catch (TransformationException e) {
                    log.error((Object)sourceRecord);
                    throw new IllegalStateException(e);
                }
                ++index;
            }
        } else {
            for (String record : objectRecords) {
                try {
                    log.debug((Object)("now run transformation for record with index: " + index));
                    try {
                        String transformedRecord = this.transformation.transformRecord(record, this.stylesheetParams);
                        this.mdRecords.add(transformedRecord);
                    }
                    catch (TerminationException e) {
                        String failedRecord = this.transformation.transformRecord(record, "syntaxcheckfailed.xsl");
                        ++this.totalIgnoredRecords;
                        log.debug((Object)failedRecord);
                        this.mdRecords.add(failedRecord);
                    }
                }
                catch (TransformationException e) {
                    log.error((Object)sourceRecord);
                    throw new IllegalStateException(e);
                }
                ++index;
            }
        }
        this.totalTransformedRecords += (long)this.mdRecords.size();
        log.debug((Object)("objRecordSize: " + objectRecords.size() + ", mdRecordSize: " + this.mdRecords.size() + ", ignoredRecordSize: " + this.totalIgnoredRecords));
        return this.mdRecords.get(0);
    }

    private void calculateStylesheetParams(String aRecord) throws XPathExpressionException, ProcessingException {
        this.stylesheetParamsCalculated = true;
        XPath xpath = XPathFactory.newInstance().newXPath();
        Node root = (Node)xpath.evaluate("/", new InputSource(new StringReader(aRecord)), XPathConstants.NODE);
        String datasourcePrefix = xpath.evaluate("//*[local-name()='datasourceprefix']", root);
        String profileXquery = "collection('/db/DRIVER/RepositoryServiceResources')//RESOURCE_PROFILE[.//EXTRA_FIELDS/FIELD[key=\"NamespacePrefix\"][value=\"" + datasourcePrefix + "\"]]";
        log.debug((Object)("profileXquery: " + profileXquery));
        RetrieveValue retrieveValue = new RetrieveValue();
        retrieveValue.setResourceDao(this.resourceDao);
        LinkedList<Argument> argList = new LinkedList<Argument>();
        argList.add(new Argument(Argument.Type.VALUE, profileXquery));
        Argument argXpath = new Argument(Argument.Type.INPUTFIELD, "//OFFICIAL_NAME");
        argList.add(argXpath);
        String varOfficialName = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varOfficialName", varOfficialName);
        argList.remove(argXpath);
        argXpath = new Argument(Argument.Type.INPUTFIELD, "//EXTRA_FIELDS/FIELD[key='OpenAireDataSourceId']/value");
        argList.add(argXpath);
        String varDataSourceId = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varDataSourceId", varDataSourceId);
        argList.remove(argXpath);
        argXpath = new Argument(Argument.Type.INPUTFIELD, "//CONFIGURATION/DATASOURCE_TYPE");
        argList.add(argXpath);
        String varDsType = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
        this.stylesheetParams.put("varDsType", varDsType);
        argList.remove(argXpath);
        for (Map<String, String> preprocMap : this.transformation.getRuleLanguageParser().getPreprocessings()) {
            for (String function : preprocMap.keySet()) {
                if (!function.equals("blacklist")) continue;
                argXpath = new Argument(Argument.Type.INPUTFIELD, preprocMap.get(function));
                argList.add(argXpath);
                String varBlacklistDataSourceId = retrieveValue.executeSingleValue(RetrieveValue.FUNCTION.PROFILEFIELD.toString(), argList, null, new HashMap<String, String>());
                this.stylesheetParams.put("varBlacklistDataSourceId", varBlacklistDataSourceId);
                argList.remove(argXpath);
            }
        }
    }

    private void initTransformationFunction() {
        if (this.vocabularyRegistry == null) {
            throw new IllegalStateException("vocabularyReg is null");
        }
        Convert convertFunction = new Convert();
        convertFunction.setVocabularyRegistry(this.vocabularyRegistry);
        TransformationFunctionProxy.getInstance().setConvertFunction(convertFunction);
    }

    private void preprocess(List<String> records, FunctionCall aFunctionCall) {
        try {
            log.debug((Object)"preprocess");
            if (this.transformation.getRuleLanguageParser() == null) {
                throw new IllegalStateException("rulelanguageparser not initialised");
            }
            if (this.transformation.getRuleLanguageParser().getNamespaceDeclarations() == null) {
                throw new IllegalStateException("nsDecl is null");
            }
            PreProcessor preProc = new PreProcessor();
            preProc.setConvertFunction(TransformationFunctionProxy.getInstance().getConvertFunction());
            RetrieveValue retrieveValue = new RetrieveValue();
            retrieveValue.setResourceDao(this.resourceDao);
            preProc.setRetrieveFunction(retrieveValue);
            RegularExpression regExpr = new RegularExpression();
            preProc.setRegExprFunction(regExpr);
            TransformationFunctionProxy functionProxy = TransformationFunctionProxy.getInstance();
            preProc.setFunctionProxy(functionProxy);
            Extract extractFunction = new Extract();
            extractFunction.setFeatureExtraction(this.featureExtraction);
            preProc.setExtractFunction(extractFunction);
            if (aFunctionCall.doPreprocess() || aFunctionCall.isStatic()) {
                preProc.preprocess(aFunctionCall, records, this.transformation.getRuleLanguageParser().getNamespaceDeclarations(), this.transformation.getStaticTransformationResults(), this.transformation.getJobProperties(), this.transformation.getRuleLanguageParser().getVariableMappingRules());
            } else {
                log.debug((Object)("skip preprocessing for function: " + aFunctionCall.getExternalFunctionName()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public ITransformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(ITransformation transformation) {
        this.transformation = transformation;
    }

    public VocabularyRegistry getVocabularyRegistry() {
        return this.vocabularyRegistry;
    }

    public void setVocabularyRegistry(VocabularyRegistry vocabularyRegistry) {
        this.vocabularyRegistry = vocabularyRegistry;
    }

    public ResourceDao getResourceDao() {
        return this.resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public IFeatureExtraction getFeatureExtraction() {
        return this.featureExtraction;
    }

    public void setFeatureExtraction(IFeatureExtraction featureExtraction) {
        this.featureExtraction = featureExtraction;
    }

    public IDatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }

    public void setDatabaseConnector(IDatabaseConnector databaseConnector) {
        this.databaseConnector = databaseConnector;
    }

    public long getTotalTransformedRecords() {
        return this.totalTransformedRecords;
    }

    public long getTotalIgnoredRecords() {
        return this.totalIgnoredRecords;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(String mappingFile) {
        this.mappingFile = mappingFile;
    }

    public Resource getBlacklistApi() {
        return this.blacklistApi;
    }

    public void setBlacklistApi(Resource blacklistApi) {
        this.blacklistApi = blacklistApi;
    }
}

