/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.archive.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZipIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(ZipIterator.class);
    ZipFile zipFile;
    Enumeration<? extends ZipEntry> entries;
    private String current;

    public ZipIterator(String zipPath) {
        try {
            this.zipFile = new ZipFile(zipPath);
            this.entries = this.zipFile.entries();
            this.current = this.findNext();
        }
        catch (IOException e) {
            log.error((Object)("Problems opening the .zip file " + zipPath), (Throwable)e);
        }
    }

    public ZipIterator(File file) {
        try {
            this.zipFile = new ZipFile(file);
            this.entries = this.zipFile.entries();
            this.current = this.findNext();
        }
        catch (IOException e) {
            log.error((Object)("Problems opening the .zip file " + this.zipFile.getName()), (Throwable)e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.current != null;
    }

    @Override
    public String next() {
        String ret = new String(this.current);
        this.current = this.findNext();
        return ret;
    }

    @Override
    public void remove() {
    }

    private synchronized String findNext() {
        ZipEntry entry = null;
        while (this.entries.hasMoreElements() && (entry = this.entries.nextElement()).isDirectory()) {
            log.debug((Object)("Skipping Zip entry " + entry.getName()));
        }
        if (entry == null) {
            return null;
        }
        log.debug((Object)("Extracting " + entry.getName()));
        try {
            InputStream stream = this.zipFile.getInputStream(entry);
            return IOUtils.toString((InputStream)stream);
        }
        catch (IOException e) {
            log.error((Object)("Problems extracting entry " + entry.getName()), (Throwable)e);
            return null;
        }
    }
}

