/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.transformation.service;

import eu.dnetlib.common.profile.ProfileNotFoundException;
import eu.dnetlib.common.profile.ResourceDao;
import eu.dnetlib.data.collective.transformation.VocabularyRegistry;
import eu.dnetlib.data.collective.transformation.engine.SimpleTransformationEngine;
import eu.dnetlib.data.collective.transformation.engine.core.TransformationImpl;
import eu.dnetlib.data.collective.transformation.utils.TransformationRulesImportTool;
import java.util.function.UnaryOperator;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class SimpleDataTransformer
implements UnaryOperator<String> {
    private static final Log log = LogFactory.getLog(SimpleDataTransformer.class);
    private String ruleProfile;
    private SimpleTransformationEngine transformationEngine;

    public SimpleDataTransformer(String ruleProfile) {
        this.ruleProfile = ruleProfile;
        if (log.isDebugEnabled()) {
            log.debug((Object)"************************************************************");
            log.debug((Object)("New transformer created from profile " + ruleProfile));
            log.debug((Object)"************************************************************");
        }
    }

    @Override
    public String apply(String record) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"************************************************************");
            log.debug((Object)("INPUT: " + record));
            log.debug((Object)"************************************************************");
        }
        String output = this.transform(record);
        if (log.isDebugEnabled()) {
            log.debug((Object)"************************************************************");
            log.debug((Object)("OUTPUT: " + output));
            log.debug((Object)"************************************************************");
        }
        return output;
    }

    private String transform(String record) {
        return this.transformationEngine.transform(record);
    }

    protected void setupEngine(VocabularyRegistry vocabularyRegistry, Resource transformationTemplate, Resource defaultSchema, TransformationRulesImportTool rulesProfileUtil, ResourceDao resourceDao, Resource blacklistApi) throws TransformerConfigurationException, ProfileNotFoundException {
        this.transformationEngine = new SimpleTransformationEngine();
        this.transformationEngine.setVocabularyRegistry(vocabularyRegistry);
        TransformationImpl transformation = new TransformationImpl();
        transformation.setSchema(defaultSchema);
        transformation.setTemplate(transformationTemplate);
        transformation.init();
        if (log.isDebugEnabled()) {
            log.debug((Object)"************************************************************");
            log.debug((Object)this.ruleProfile);
            log.debug((Object)"************************************************************");
        }
        transformation.setRuleLanguageParser(rulesProfileUtil.getRuleLanguageParser(this.ruleProfile));
        transformation.configureTransformation();
        this.transformationEngine.setTransformation(transformation);
        this.transformationEngine.setResourceDao(resourceDao);
        this.transformationEngine.setBlacklistApi(blacklistApi);
    }

    public String getRuleProfile() {
        return this.ruleProfile;
    }

    public void setRuleProfile(String ruleProfile) {
        this.ruleProfile = ruleProfile;
    }
}

