/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.collect.Lists;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.MDStoreRetriever;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ModularMDStoreService
extends AbstractBaseService
implements MDStoreService {
    private NotificationHandler notificationHandler;
    private MDStoreFeeder feeder;
    private MDStoreRetriever retriever;
    @Autowired
    private ResultSetFactory resultSetFactory;

    public ResultSet<String> deliverMDRecords(String mdId, String from, String until, String recordFilter) throws MDStoreServiceException {
        return this.retriever.deliver(mdId, from, until, recordFilter);
    }

    public ResultSet<String> bulkDeliverMDRecords(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.resultSetFactory.createResultSet(this.retriever.deliver(format, layout, interpretation));
    }

    public String deliverRecord(String mdId, String recordId) throws MDStoreServiceException {
        return this.retriever.deliverRecord(mdId, recordId);
    }

    public List<String> getListOfMDStores() throws MDStoreServiceException {
        return Lists.transform(this.retriever.getDao().listMDStores(), input -> input.getId());
    }

    public List<String> listMDStores(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.retriever.getDao().listMDStores(format, layout, interpretation);
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public boolean storeMDRecordsFromRS(String mdId, String rsId, String storingType) throws MDStoreServiceException {
        throw new MDStoreServiceException("not implemented, use the Blackboard asynchronous equivalent");
    }

    public int size(String mdId) throws MDStoreServiceException {
        return this.getRetriever().getDao().getCachedSize(mdId);
    }

    public int size(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.getRetriever().getDao().getSumOfSizes(format, layout, interpretation);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public MDStoreRetriever getRetriever() {
        return this.retriever;
    }

    public void setRetriever(MDStoreRetriever retriever) {
        this.retriever = retriever;
    }
}

