package eu.dnetlib.data.collector.plugins.httplist;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.plugin.AbstractCollectorPlugin;

public class HttpListCollectorPlugin extends AbstractCollectorPlugin {

	@Override
	public Iterable<String> collect(final InterfaceDescriptor interfaceDescriptor, final String fromDate, final String untilDate)
			throws CollectorServiceException {
		final String baseUrl = interfaceDescriptor.getBaseUrl();
		final String listAddress = interfaceDescriptor.getParams().get("listUrl");

		return () -> new HttpListIterator(baseUrl, listAddress);
	}
}
