package eu.dnetlib.data.mdstore.modular;

import java.util.List;
import java.util.stream.Stream;

import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DocumentNotFoundException;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreRetriever {

	/**
	 * Logger
	 */
	private static final Log log = LogFactory.getLog(MDStoreRetriever.class);

	private MDStoreDao dao;

	private ResultSetFactory resultSetFactory;

	public ResultSet<String> deliver(final String mdId, final String from, final String until, final String recordFilter) throws MDStoreServiceException {
		final MDStore mdStore = dao.readMDStore(mdId);
		return getResultSetFactory().createResultSet(mdStore.deliver(from, until, recordFilter));
	}

	public Iterable<String> deliver(final String format, final String layout, final String interpretation) throws MDStoreServiceException {
		return () -> getMdIds(format, layout, interpretation).stream().map(mdId -> {
			log.debug("bulk deliver of mdId: " + mdId);
			try {
				return DnetStreamSupport.generateStreamFromIterator(dao.readMDStore(mdId).iterate().iterator());
            } catch (Throwable e) {
                throw new RuntimeException(e);
			}
		}).reduce(Stream::concat).orElseGet(Stream::empty).iterator();
	}

	private List<String> getMdIds(final String format, final String layout, final String interpretation) {
		try {
			return dao.listMDStores(format, layout, interpretation);
		} catch (MDStoreServiceException e) {
			throw new RuntimeException(e);
		}
	}

	public String deliverRecord(final String mdId, final String recordId) throws MDStoreServiceException, DocumentNotFoundException {
		return dao.getMDStore(mdId).getRecord(recordId);
	}

	public MDStoreDao getDao() {
		return dao;
	}

	@Required
	public void setDao(final MDStoreDao dao) {
		this.dao = dao;
	}

	public ResultSetFactory getResultSetFactory() {
		return resultSetFactory;
	}

	@Required
	public void setResultSetFactory(final ResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

}
