package eu.dnetlib.data.mdstore.modular.action;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;

public class DummyPlugin implements MDStorePlugin {

	private static final Log log = LogFactory.getLog(DummyPlugin.class);

	@Override
	public void run(final MDStoreDao dao, final Map<String, String> params, final DoneCallback done, final FailedCallback failedCallback) {
		try {
			log.info("Nothing to do, I'm a dummy plugin. Bye.");
			final HashMap<String, String> res = new HashMap<>();
			res.put("ret", "cheers!");
			done.call(res);
		} catch (final Throwable e) {
			log.error(e.getMessage(), e);
			failedCallback.call(e);
		}
	}

}
