/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import eu.dnetlib.data.mdstore.modular.MDStoreDescription;
import eu.dnetlib.data.mdstore.modular.RecordParserFactory;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDBStatus;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.data.mdstore.modular.mongodb.MongoMDStore;
import eu.dnetlib.data.mdstore.modular.mongodb.utils.MDStoreUtils;
import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreDaoImpl
implements MDStoreDao {
    public static final String MD_ID = "mdId";
    public static final String FORMAT = "format";
    public static final String INTERPRETATION = "interpretation";
    public static final String LAYOUT = "layout";
    public static final String SIZE = "size";
    public static final String METADATA_NAME = "metadata";
    private static final Log log = LogFactory.getLog(MDStoreDaoImpl.class);
    private MongoDatabase db;
    private RecordParserFactory recordParserFactory;
    private boolean discardRecords = true;
    @Autowired
    private MDStoreTransactionManager transactionManager;

    @Override
    public void createMDStore(String mdId, String format, String interpretation, String layout) throws MDStoreServiceException {
        this.transactionManager.createMDStore(mdId);
        String internalId = this.transactionManager.getMDStoreCollection(mdId);
        List collect = DnetStreamSupport.generateStreamFromIterator((Iterator)this.getDb().listCollectionNames().iterator()).filter(collection -> collection.contains(internalId)).collect(Collectors.toList());
        if (collect.size() == 0) {
            log.info((Object)String.format("creating collection %s", internalId));
            this.getDb().createCollection(internalId, new CreateCollectionOptions());
        }
        MongoCollection coll = this.getDb().getCollection(METADATA_NAME, DBObject.class);
        BasicDBObject obj = new BasicDBObject();
        obj.put((Object)MD_ID, (Object)mdId);
        obj.put((Object)FORMAT, (Object)format);
        obj.put((Object)INTERPRETATION, (Object)interpretation);
        obj.put((Object)LAYOUT, (Object)layout);
        obj.put((Object)SIZE, (Object)0);
        coll.insertOne((Object)obj);
    }

    @Override
    public void deleteMDStore(String mdId) throws MDStoreServiceException {
        MongoCollection metadata = this.getDb().getCollection(METADATA_NAME, DBObject.class);
        if (metadata == null) {
            throw new MDStoreServiceException("cannot find metadata collection");
        }
        this.transactionManager.dropMDStore(mdId);
        metadata.deleteOne((Bson)new BasicDBObject(MD_ID, (Object)mdId));
        log.info((Object)("deleted mdId: " + mdId));
    }

    @Override
    public MDStore getMDStore(String mdId) throws MDStoreServiceException {
        String internalId = this.transactionManager.getMDStoreCollection(mdId);
        return new MongoMDStore(mdId, (MongoCollection<DBObject>)this.getDb().getCollection(internalId, DBObject.class), this.getRecordParserFactory().newInstance(), this.isDiscardRecords(), this.getDb());
    }

    @Override
    public MDStore readMDStore(String mdId) throws MDStoreServiceException {
        String internalId = this.transactionManager.readMdStore(mdId);
        return new MongoMDStore(mdId, (MongoCollection<DBObject>)this.getDb().getCollection(internalId, DBObject.class), this.getRecordParserFactory().newInstance(), this.isDiscardRecords(), this.getDb());
    }

    @Override
    public MDStore startTransaction(String mdId, boolean refresh) throws MDStoreServiceException {
        String transactionId = this.transactionManager.startTransaction(mdId, refresh);
        return new MongoMDStore(transactionId, (MongoCollection<DBObject>)this.getDb().getCollection(transactionId, DBObject.class), this.getRecordParserFactory().newInstance(), this.isDiscardRecords(), this.getDb());
    }

    @Override
    public List<MDStoreDescription> listMDStores() {
        return DnetStreamSupport.generateStreamFromIterator((Iterator)this.getDb().getCollection(METADATA_NAME, DBObject.class).find().iterator()).map(this::convertMDStoreDescription).collect(Collectors.toList());
    }

    private MDStoreDescription convertMDStoreDescription(DBObject input) {
        String mdId = (String)input.get(MD_ID);
        log.debug((Object)("Getting info for " + mdId));
        String format = (String)input.get(FORMAT);
        String layout = (String)input.get(LAYOUT);
        String interpretation = (String)input.get(INTERPRETATION);
        MongoMDStore currentMDStore = null;
        MDStoreDescription description = new MDStoreDescription();
        try {
            currentMDStore = (MongoMDStore)this.getMDStore(mdId);
        }
        catch (MDStoreServiceException e) {
            log.error((Object)("Error on retrieving mdstore for getting info mdId " + mdId));
        }
        int size = 0;
        if (input.containsField(SIZE)) {
            log.debug((Object)("Size retrieved from metadata for mdId :" + mdId));
            size = (Integer)input.get(SIZE);
        } else if (currentMDStore != null) {
            log.debug((Object)("Size not Found in metadata for mdId :" + mdId + " calling getCount "));
            size = currentMDStore.getSize();
            input.put(SIZE, (Object)size);
            this.getDb().getCollection(METADATA_NAME, DBObject.class).findOneAndReplace((Bson)new BasicDBObject(MD_ID, (Object)mdId), (Object)input);
        }
        if (currentMDStore != null) {
            description.setIndexed(currentMDStore.isIndexed());
        }
        description.setId(mdId);
        description.setFormat(format);
        description.setLayout(layout);
        description.setInterpretation(interpretation);
        description.setSize(size);
        return description;
    }

    @Override
    public List<String> listMDStores(String format, String layout, String interpretation) {
        return DnetStreamSupport.generateStreamFromIterator((Iterator)this.getDb().getCollection(METADATA_NAME, DBObject.class).find().iterator()).filter(MDStoreUtils.dboFilter(format, layout, interpretation)).map(MDStoreUtils.mdId()).collect(Collectors.toList());
    }

    @Override
    public int getCachedSize(String id) throws MDStoreServiceException {
        log.debug((Object)("retrieve cached size for mdstore: " + id));
        DBObject desc = (DBObject)this.getDb().getCollection(METADATA_NAME, DBObject.class).find((Bson)new BasicDBObject(MD_ID, (Object)id)).first();
        if (!desc.containsField(SIZE)) {
            desc.put(SIZE, (Object)this.getMDStore(id).getSize());
        }
        Object oSize = desc.get(SIZE);
        return (Integer)oSize;
    }

    @Override
    public void refreshSizes() throws MDStoreServiceException {
        for (MDStoreDescription mdStoreId : this.listMDStores()) {
            this.refreshSize(mdStoreId.getId());
        }
    }

    @Override
    public int refreshSize(String mdStoreId) throws MDStoreServiceException {
        int size = (int)this.getDb().getCollection(this.transactionManager.getMDStoreCollection(mdStoreId)).count();
        MongoCollection metadata = this.getDb().getCollection(METADATA_NAME, DBObject.class);
        metadata.updateOne((Bson)new BasicDBObject(MD_ID, (Object)mdStoreId), (Bson)new BasicDBObject("$set", (Object)new BasicDBObject(SIZE, (Object)size)));
        return size;
    }

    @Override
    public int getSumOfSizes(String format, String layout, String interpretation) throws MDStoreServiceException {
        BasicDBObject projectObj;
        BasicDBObject groupObj;
        BasicDBObject matchObj;
        ArrayList pipeline;
        MongoCollection metadata = this.getDb().getCollection(METADATA_NAME, DBObject.class);
        AggregateIterable output = metadata.aggregate((List)(pipeline = Lists.newArrayList((Object[])new BasicDBObject[]{matchObj = (BasicDBObject)BasicDBObjectBuilder.start((String)"$match", (Object)BasicDBObjectBuilder.start((String)FORMAT, (Object)format).add(LAYOUT, (Object)layout).add(INTERPRETATION, (Object)interpretation).get()).get(), groupObj = (BasicDBObject)BasicDBObjectBuilder.start((String)"$group", (Object)BasicDBObjectBuilder.start((String)"_id", (Object)"").add("total", (Object)new BasicDBObject("$sum", (Object)"$size")).get()).get(), projectObj = new BasicDBObject("$project", (Object)new BasicDBObject("_id", (Object)0).append("total", (Object)1))})), DBObject.class);
        DBObject result = (DBObject)output.first();
        if (result == null || !result.containsField("total")) {
            log.debug((Object)"No total found");
            return 0;
        }
        return (Integer)result.get("total");
    }

    @Override
    public void commit(String transactionId, String mdId) throws MDStoreServiceException {
        this.transactionManager.commit(transactionId, mdId, this.getMDStore(mdId));
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    @Required
    public void setDb(MongoDatabase db) {
        this.db = db;
    }

    public RecordParserFactory getRecordParserFactory() {
        return this.recordParserFactory;
    }

    @Required
    public void setRecordParserFactory(RecordParserFactory recordParserFactory) {
        this.recordParserFactory = recordParserFactory;
    }

    public boolean isDiscardRecords() {
        return this.discardRecords;
    }

    public void setDiscardRecords(boolean discardRecords) {
        this.discardRecords = discardRecords;
    }

    @Override
    public MDStoreDBStatus getDBStatus() {
        int handledDatastructures = Ints.saturatedCast((long)this.getDb().getCollection(METADATA_NAME).count());
        BasicDBObject statsQuery = new BasicDBObject("dbStats", (Object)1);
        statsQuery.put((Object)"scale", (Object)0x100000);
        Document statsRes = this.getDb().runCommand((Bson)statsQuery);
        log.debug((Object)("DBStatus --  " + statsRes.toJson()));
        int usedDiskSpace = 0;
        String usedDiskSpaceStr = statsRes.get((Object)"storageSize").toString();
        try {
            Long usedDiskSpaceLong = Long.parseLong(usedDiskSpaceStr);
            usedDiskSpace = Ints.saturatedCast((long)usedDiskSpaceLong);
        }
        catch (NumberFormatException nfe) {
            Double usedDiskSpaceDbl = Double.parseDouble(usedDiskSpaceStr);
            usedDiskSpace = usedDiskSpaceDbl.intValue();
        }
        String date = DateUtils.now_ISO8601();
        return new MDStoreDBStatus(handledDatastructures, usedDiskSpace, date);
    }

    @Override
    public void startGarbage(boolean hardGarbage) throws MDStoreServiceException {
        if (hardGarbage) {
            this.transactionManager.hardGarbage();
        } else {
            this.transactionManager.garbage();
        }
    }

    @Override
    public void invalidTransaction(String transactionId, String mdId) throws MDStoreServiceException {
        this.transactionManager.dropTransaction(mdId, transactionId);
    }
}

