package eu.dnetlib.data.mdstore.modular;

import com.google.common.collect.Iterables;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.DocumentNotFoundException;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreRetriever {

	/**
	 * Logger
	 */
	private static final Log log = LogFactory.getLog(MDStoreRetriever.class);

	private MDStoreDao dao;

	private ResultSetFactory resultSetFactory;

	public ResultSet<String> deliver(final String mdId, final String from, final String until, final String recordFilter, final boolean noCursorTimeout) throws MDStoreServiceException {
		final MDStore mdStore = dao.readMDStore(mdId);
		return getResultSetFactory().createResultSet(mdStore.deliver(from, until, recordFilter, noCursorTimeout));
	}

	public Iterable<String> deliver(final String format, final String layout, final String interpretation) throws MDStoreServiceException {
		try {
			return Iterables.concat(Iterables.transform(dao.listMDStores(format, layout, interpretation), mdId -> {
				log.debug("bulk deliver of mdId: " + mdId);
				try {
					return dao.readMDStore(mdId).iterate();
				} catch (MDStoreServiceException e) {
					throw new RuntimeException(e);
				}
			}));
		} catch (RuntimeException e) {
			throw new MDStoreServiceException(e);
		}
	}

	public String deliverRecord(final String mdId, final String recordId) throws MDStoreServiceException, DocumentNotFoundException {
		return dao.getMDStore(mdId).getRecord(recordId);
	}

	public MDStoreDao getDao() {
		return dao;
	}

	@Required
	public void setDao(final MDStoreDao dao) {
		this.dao = dao;
	}

	public ResultSetFactory getResultSetFactory() {
		return resultSetFactory;
	}

	@Required
	public void setResultSetFactory(final ResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

}
