/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore;

import eu.dnetlib.data.objectstore.AbstractObjectStoreAction;
import eu.dnetlib.data.objectstore.ObjectStoreProfileCreator;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CreateObjectStoreAction
extends AbstractObjectStoreAction {
    private static final Log log = LogFactory.getLog(CreateObjectStoreAction.class);
    @Autowired
    private UniqueServiceLocator locator;
    private ObjectStoreProfileCreator profileCreator;

    public ObjectStoreProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    public void setProfileCreator(ObjectStoreProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
    }

    @Override
    protected void executeAsync(BlackboardServerHandler handler, BlackboardJob job) {
        try {
            String objID;
            String interpretation = (String)job.getParameters().get("interpretation");
            String basePath = (String)job.getParameters().get("basePath");
            boolean createOnlyIfMissing = BooleanUtils.toBoolean((String)((String)job.getParameters().get("createOnlyIfMissing")));
            if (createOnlyIfMissing && (objID = this.findObjectStoreByInterpretation(interpretation)) != null) {
                job.getParameters().put("objectStoreId", objID);
                this.completeWithSuccess(handler, job);
                return;
            }
            objID = this.profileCreator.registerProfile(interpretation);
            this.getDao().createObjectStore(objID, interpretation, basePath);
            job.getParameters().put("objectStoreId", objID);
            this.completeWithSuccess(handler, job);
        }
        catch (Exception e) {
            this.completeWithFail(handler, job, e);
        }
    }

    private String findObjectStoreByInterpretation(String interpretation) {
        ISLookUpService service = (ISLookUpService)this.locator.getService(ISLookUpService.class);
        String query = "for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') where $x//OBJECTSTORE_INTERPRETATION='%s' return $x//RESOURCE_IDENTIFIER/@value/string()";
        try {
            List strings = service.quickSearchProfile(String.format("for $x in collection('/db/DRIVER/ObjectStoreDSResources/ObjectStoreDSResourceType') where $x//OBJECTSTORE_INTERPRETATION='%s' return $x//RESOURCE_IDENTIFIER/@value/string()", interpretation));
            if (strings != null && strings.size() > 0) {
                return (String)strings.get(0);
            }
        }
        catch (ISLookUpException e) {
            log.error((Object)"error on executing query", (Throwable)e);
        }
        return null;
    }
}

