package eu.dnetlib.data.collector;

import java.util.Collection;

import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;

public class CollectorPluginEnumerator implements BeanFactoryAware {

	// private static final Log log = LogFactory.getLog(CollectorPluginEnumerator.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * bean factory.
	 */
	private ListableBeanFactory beanFactory;

	/**
	 * Get all beans implementing the CollectorPlugin interface.
	 *
	 * @return
	 */
	public Collection<CollectorPlugin> getAll() {
		return beanFactory.getBeansOfType(CollectorPlugin.class).values();
	}

	public ListableBeanFactory getBeanFactory() {
		return beanFactory;
	}

	@Override
	public void setBeanFactory(final BeanFactory beanFactory) throws BeansException {
		this.beanFactory = (ListableBeanFactory) beanFactory;
	}

	/**
	 * Get given CollectorPlugin or throws exception.
	 *
	 * @param protocol
	 * @return
	 * @throws CollectorServiceException
	 */
	public CollectorPlugin get(final String protocol) throws CollectorServiceException {
		for (CollectorPlugin cp : getAll()) {
			if (protocol.equalsIgnoreCase(cp.getProtocol())) {
				return cp;
			}
		}
		throw new CollectorServiceException("plugin not found for protocol: " + protocol);
	}
}
