/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.objectstore.worker;

import com.google.common.base.Joiner;
import eu.dnetlib.data.objectstore.DownloadReportMap;
import eu.dnetlib.data.objectstore.DownloadServiceFeeder;
import eu.dnetlib.data.objectstore.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.connector.ObjectStore;
import eu.dnetlib.rmi.data.DownloadItem;
import eu.dnetlib.rmi.data.ObjectStoreFile;
import eu.dnetlib.rmi.data.Protocols;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker
implements Callable<DownloadReportMap> {
    private static final Log log = LogFactory.getLog(DownloadWorker.class);
    private static final int MAX_NULLS = 5;
    private BlockingQueue<String> queue = null;
    private ObjectStore objectStore = null;
    private Protocols protocol;
    private String mimeType;
    private Function<String, DownloadItem> converter;
    private int connectTimeoutMs;
    private int readTimeoutMs;
    private int sleepTimeMs;

    public DownloadWorker(BlockingQueue<String> queue, ObjectStore objectStore, Protocols protocol, String mimeType, int connectTimeoutMs, int readTimeoutMs, int sleepTimeMs, Function<String, DownloadItem> converter) {
        this.setConverter(converter);
        this.setQueue(queue);
        this.setObjectStore(objectStore);
        this.setMimeType(mimeType);
        this.setProtocol(protocol);
        this.setConnectTimeoutMs(connectTimeoutMs);
        this.setReadTimeoutMs(readTimeoutMs);
        this.setSleepTimeMs(sleepTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadReportMap call() throws Exception {
        DownloadReportMap report = new DownloadReportMap();
        long threadId = Thread.currentThread().getId();
        int nullCounter = 0;
        try {
            String takedObject = this.queue.poll(5L, TimeUnit.SECONDS);
            while (!"END_DOWNLOAD".equals(takedObject) && nullCounter < 5) {
                if (takedObject == null) {
                    ++nullCounter;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)takedObject);
                }
                DownloadItem di = this.getConverter().apply(takedObject);
                log.debug((Object)(threadId + ": Reading " + takedObject));
                if (di == null) {
                    log.info((Object)"the current download item is Null, skipping");
                    DownloadServiceFeeder.reportException(report, null, new IllegalArgumentException("found null DownloadItem"));
                } else if (StringUtils.isNotBlank((CharSequence)di.getUrl()) && !this.checkIfExists(di)) {
                    this.doDownload(threadId, report, di);
                }
                takedObject = this.queue.poll(5L, TimeUnit.SECONDS);
                log.debug((Object)String.format("%s: next object from queue %s, remaining items: %s", threadId, takedObject, this.queue.size()));
            }
        }
        catch (Exception e) {
            DownloadReportMap downloadReportMap;
            try {
                log.error((Object)("An error occured : " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
                DownloadServiceFeeder.reportException(report, null, e);
                report.setStatus(false);
                downloadReportMap = report;
            }
            catch (Throwable throwable) {
                log.info((Object)String.format("%s: finalising queue, remaining items: %s, nulls: %s", threadId, this.queue.size(), nullCounter));
                boolean res = this.queue.offer("END_DOWNLOAD", 5L, TimeUnit.SECONDS);
                log.info((Object)("put terminator in queue: " + res));
                throw throwable;
            }
            log.info((Object)String.format("%s: finalising queue, remaining items: %s, nulls: %s", threadId, this.queue.size(), nullCounter));
            boolean res = this.queue.offer("END_DOWNLOAD", 5L, TimeUnit.SECONDS);
            log.info((Object)("put terminator in queue: " + res));
            return downloadReportMap;
        }
        log.info((Object)String.format("%s: finalising queue, remaining items: %s, nulls: %s", threadId, this.queue.size(), nullCounter));
        boolean res = this.queue.offer("END_DOWNLOAD", 5L, TimeUnit.SECONDS);
        log.info((Object)("put terminator in queue: " + res));
        log.info((Object)("CLOSED THREAD " + threadId));
        report.setStatus(true);
        return report;
    }

    private void doDownload(long threadId, DownloadReportMap report, DownloadItem di) {
        try {
            if (this.getSleepTimeMs() > 0) {
                log.debug((Object)(threadId + ": I will sleep for " + this.getSleepTimeMs() + " ms, as requested..."));
                Thread.sleep(this.getSleepTimeMs());
            }
            URL toDownload = this.followURL(threadId, new URL(di.getUrl()), report, di);
            ObjectStoreRecord record = new ObjectStoreRecord();
            ObjectStoreFile metadata = new ObjectStoreFile();
            metadata.setObjectID(di.getFileName());
            metadata.setMetadataRelatedID(di.getIdItemMetadata());
            metadata.setAccessProtocol(this.protocol);
            metadata.setMimeType(this.mimeType);
            metadata.setDownloadedURL(di.getOriginalUrl());
            record.setFileMetadata(metadata);
            log.debug((Object)(threadId + ": opening connection " + toDownload));
            URLConnection connection = toDownload.openConnection();
            connection.setConnectTimeout(this.getConnectTimeoutMs());
            connection.setReadTimeout(this.getReadTimeoutMs());
            log.debug((Object)(threadId + ": getting input stream from " + toDownload));
            record.setInputStream(connection.getInputStream());
            log.debug((Object)(threadId + ": feeding object from  " + toDownload + " into objectstore ..."));
            this.objectStore.feedObjectRecord(record);
            report.addDowload();
            log.debug((Object)(threadId + ": saved object " + metadata.toJSON()));
        }
        catch (Throwable e) {
            log.error((Object)(threadId + ": error downloading Item: " + di.toJSON()), e);
            DownloadServiceFeeder.reportException(report, di, e);
        }
    }

    private URL followURL(long threadId, URL inputURL, DownloadReportMap report, DownloadItem di) throws IOException {
        String ptrcl = inputURL.getProtocol();
        if (ptrcl.startsWith("file")) {
            log.debug((Object)("the protocol is File, returning " + inputURL));
            return inputURL;
        }
        HttpURLConnection conn = (HttpURLConnection)inputURL.openConnection();
        conn.setInstanceFollowRedirects(true);
        conn.setReadTimeout(this.getReadTimeoutMs());
        conn.setConnectTimeout(this.getConnectTimeoutMs());
        String location = inputURL.toString();
        log.debug((Object)(threadId + " : followURL connecting  " + inputURL));
        conn.connect();
        log.debug((Object)(threadId + " : followURL connected  " + inputURL));
        int responseCode = conn.getResponseCode();
        log.debug((Object)(threadId + " : followURL " + inputURL + ", response code: " + responseCode));
        if (responseCode >= 300 && responseCode < 400) {
            location = conn.getHeaderFields().get("Location").get(0);
            conn.disconnect();
            log.debug((Object)(threadId + " : followURL disconnected  " + inputURL));
        }
        if (!location.equals(inputURL.toString())) {
            return new URL(location);
        }
        return inputURL;
    }

    private boolean checkIfExists(DownloadItem di) {
        try {
            return this.objectStore.alreadyExist(di.getFileName());
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage());
            return false;
        }
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public void setQueue(BlockingQueue<String> queue) {
        this.queue = queue;
    }

    public void setProtocol(Protocols protocol) {
        this.protocol = protocol;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Function<String, DownloadItem> getConverter() {
        return this.converter;
    }

    public void setConverter(Function<String, DownloadItem> converter) {
        this.converter = converter;
    }

    public int getReadTimeoutMs() {
        return this.readTimeoutMs;
    }

    public void setReadTimeoutMs(int readTimeoutMs) {
        this.readTimeoutMs = readTimeoutMs;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public int getSleepTimeMs() {
        return this.sleepTimeMs;
    }

    public void setSleepTimeMs(int sleepTimeMs) {
        this.sleepTimeMs = sleepTimeMs;
    }
}

