/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.oai;

import eu.dnetlib.data.collector.ThreadSafeIterator;
import eu.dnetlib.data.collector.plugins.oai.engine.HttpConnector;
import eu.dnetlib.data.collector.plugins.oai.engine.XmlCleaner;
import eu.dnetlib.rmi.data.CollectorServiceException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class OaiIterator
extends ThreadSafeIterator {
    private static final Log log = LogFactory.getLog(OaiIterator.class);
    private Queue<String> queue = new PriorityBlockingQueue<String>();
    private SAXReader reader = new SAXReader();
    private String baseUrl;
    private String set;
    private String mdFormat;
    private String fromDate;
    private String untilDate;
    private String token;
    private boolean started;
    private HttpConnector httpConnector;

    public OaiIterator(String baseUrl, String mdFormat, String set, String fromDate, String untilDate, HttpConnector httpConnector) {
        this.baseUrl = baseUrl;
        this.mdFormat = mdFormat;
        this.set = set;
        this.fromDate = fromDate;
        this.untilDate = untilDate;
        this.started = false;
        this.httpConnector = httpConnector;
    }

    private void verifyStarted() {
        if (!this.started) {
            this.started = true;
            try {
                this.token = this.firstPage();
            }
            catch (CollectorServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doHasNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doNext() {
        Queue<String> queue = this.queue;
        synchronized (queue) {
            this.verifyStarted();
            String res = this.queue.poll();
            while (this.queue.isEmpty() && this.token != null && !this.token.isEmpty()) {
                try {
                    this.token = this.otherPages(this.token);
                }
                catch (CollectorServiceException e) {
                    throw new RuntimeException(e);
                }
            }
            return res;
        }
    }

    private String firstPage() throws CollectorServiceException {
        try {
            String url = this.baseUrl + "?verb=ListRecords&metadataPrefix=" + URLEncoder.encode(this.mdFormat, "UTF-8");
            if (this.set != null && !this.set.isEmpty()) {
                url = url + "&set=" + URLEncoder.encode(this.set, "UTF-8");
            }
            if (this.fromDate != null && this.fromDate.matches("\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}Z)?+")) {
                url = url + "&from=" + URLEncoder.encode(this.fromDate, "UTF-8");
            }
            if (this.untilDate != null && this.untilDate.matches("\\d{4}-\\d{2}-\\d{2}(T\\d{2}:\\d{2}:\\d{2}Z)?+")) {
                url = url + "&until=" + URLEncoder.encode(this.untilDate, "UTF-8");
            }
            log.info((Object)("Start harvesting using url: " + url));
            return this.downloadPage(url);
        }
        catch (UnsupportedEncodingException e) {
            throw new CollectorServiceException((Throwable)e);
        }
    }

    private String otherPages(String resumptionToken) throws CollectorServiceException {
        try {
            return this.downloadPage(this.baseUrl + "?verb=ListRecords&resumptionToken=" + URLEncoder.encode(resumptionToken, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new CollectorServiceException((Throwable)e);
        }
    }

    private String downloadPage(String url) throws CollectorServiceException {
        Document doc;
        String xml = this.httpConnector.getInputSource(url);
        try {
            doc = this.reader.read((Reader)new StringReader(xml));
        }
        catch (DocumentException e) {
            log.warn((Object)("Error parsing xml, I try to clean it: " + xml), (Throwable)e);
            String cleaned = XmlCleaner.cleanAllEntities(xml);
            try {
                doc = this.reader.read((Reader)new StringReader(cleaned));
            }
            catch (DocumentException e1) {
                throw new CollectorServiceException("Error parsing cleaned document:" + cleaned, (Throwable)e1);
            }
        }
        Node errorNode = doc.selectSingleNode("/*[local-name()='OAI-PMH']/*[local-name()='error']");
        if (errorNode != null) {
            String code = errorNode.valueOf("@code");
            if ("noRecordsMatch".equalsIgnoreCase(code.trim())) {
                log.warn((Object)("noRecordsMatch for oai call: " + url));
                return null;
            }
            throw new CollectorServiceException(code + " - " + errorNode.getText());
        }
        for (Object o : doc.selectNodes("//*[local-name()='ListRecords']/*[local-name()='record']")) {
            this.queue.add(((Node)o).asXML());
        }
        return doc.valueOf("//*[local-name()='resumptionToken']");
    }
}

