package eu.dnetlib.data.collector.plugins;

import java.io.BufferedInputStream;
import java.io.IOException;
import eu.dnetlib.rmi.data.CollectorServiceException;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class HttpCollectorPlugin extends AbstractSplittedRecordPlugin {

	@Override
	protected BufferedInputStream getBufferedInputStream(final String baseUrl) throws CollectorServiceException {
		try(CloseableHttpClient client = HttpClients.createDefault()) {
			final HttpGet method = new HttpGet(baseUrl);
			try(CloseableHttpResponse response = client.execute(method)) {
				int statusCode = response.getStatusLine().getStatusCode();

				if (HttpStatus.SC_OK != statusCode) {
					throw new CollectorServiceException("Error " + statusCode + " downloading url: " + baseUrl);
				}

				return new BufferedInputStream(response.getEntity().getContent());
			}
		} catch (IOException e) {
			throw new CollectorServiceException("Error downloading url: " + baseUrl);
		}
	}

}
