/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector;

import com.google.common.collect.Sets;
import eu.dnetlib.data.collector.CollectorPluginEnumerator;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.CollectorServiceException;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.data.ProtocolDescriptor;
import eu.dnetlib.rmi.data.ProtocolParameter;
import eu.dnetlib.rmi.data.ProtocolParameterValue;
import eu.dnetlib.rmi.data.plugin.CollectorPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectorServiceImpl
extends AbstractBaseService
implements CollectorService {
    @Autowired
    private CollectorPluginEnumerator collectorPluginEnumerator;
    @Autowired
    private ResultSetFactory resultSetFactory;

    public ResultSet<String> collect(InterfaceDescriptor ifDescriptor) throws CollectorServiceException {
        return this.dateRangeCollect(ifDescriptor, null, null);
    }

    public ResultSet<String> dateRangeCollect(InterfaceDescriptor ifDescriptor, String from, String until) throws CollectorServiceException {
        CollectorPlugin plugin = this.collectorPluginEnumerator.get(ifDescriptor.getProtocol());
        if (!this.verifyParams(ifDescriptor.getParams().keySet(), Sets.newHashSet((Iterable)plugin.listNameParameters()))) {
            throw new CollectorServiceException("Invalid parameters, valid: " + plugin.listNameParameters() + ", current: " + ifDescriptor.getParams().keySet());
        }
        Iterable iter = plugin.collect(ifDescriptor, from, until);
        return this.resultSetFactory.createResultSet(iter);
    }

    public List<ProtocolDescriptor> listProtocols() {
        return this.collectorPluginEnumerator.getAll().stream().map(CollectorPlugin::getProtocolDescriptor).collect(Collectors.toList());
    }

    public List<ProtocolParameterValue> listValidValuesForParam(String protocol, String baseUrl, String param, Map<String, String> otherParams) throws CollectorServiceException {
        CollectorPlugin plugin = this.collectorPluginEnumerator.get(protocol);
        for (ProtocolParameter pp : plugin.getProtocolDescriptor().getParams()) {
            if (!pp.getName().equals(param) || !pp.isFunctionPopulated()) continue;
            return pp.getPopulateFunction().findValues(baseUrl, otherParams);
        }
        return new ArrayList<ProtocolParameterValue>();
    }

    private boolean verifyParams(Set<String> curr, Set<String> valid) {
        return valid.containsAll(curr);
    }
}

