/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import eu.dnetlib.enabling.resultset.listener.ResultSetListener;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;

public class MongoResultSetListener
implements ResultSetListener<String> {
    private static final Log log = LogFactory.getLog(MongoResultSetListener.class);
    private MongoCursor<DBObject> currentCursor;
    private Bson sortByIdAsc = Sorts.orderBy((Bson[])new Bson[]{Sorts.ascending((String[])new String[]{"id"})});
    private Function<DBObject, String> serializer;
    private MongoCollection<DBObject> collection;
    private int total = 0;
    private int count = 0;
    private int batchSize;
    private Bson query;

    public MongoResultSetListener(MongoCollection<DBObject> collection, Long from, Long until, Pattern filter, Function<DBObject, String> serializer, int batchSize, boolean noCursorTimeout) throws MDStoreServiceException {
        this.collection = collection;
        this.serializer = serializer;
        this.batchSize = batchSize;
        this.query = this.query(from, until, filter);
        this.createCursor(noCursorTimeout);
    }

    private void createCursor(boolean noCursorTimeout) throws MDStoreServiceException {
        log.debug((Object)("init mdstore cursor using query " + this.query));
        try {
            this.total = (int)this.collection.count(this.query);
            this.currentCursor = this.collection.find(this.query).batchSize(this.batchSize).sort(this.sortByIdAsc).noCursorTimeout(noCursorTimeout).iterator();
        }
        catch (Throwable e) {
            throw new MDStoreServiceException("Error on initialize the Mongodb cursor", e);
        }
    }

    private Bson query(Long from, Long until, Pattern pattern) {
        Bson regexFilter;
        Bson dateFilter = this.dateQuery(from, until);
        if (dateFilter != null & (regexFilter = this.regexQuery(pattern)) != null) {
            return Filters.and((Bson[])new Bson[]{dateFilter, regexFilter});
        }
        if (dateFilter != null) {
            return dateFilter;
        }
        if (regexFilter != null) {
            return regexFilter;
        }
        return new BasicDBObject();
    }

    private Bson dateQuery(Long from, Long until) {
        if (from != null & until != null) {
            return Filters.and((Bson[])new Bson[]{Filters.gt((String)"timestamp", (Object)from), Filters.lt((String)"timestamp", (Object)until)});
        }
        if (from != null) {
            return Filters.gt((String)"timestamp", (Object)from);
        }
        if (until != null) {
            return Filters.lt((String)"timestamp", (Object)until);
        }
        return null;
    }

    private Bson regexQuery(Pattern pattern) {
        if (pattern != null) {
            return Filters.regex((String)"body", (Pattern)pattern);
        }
        return null;
    }

    public boolean hasNext() {
        return this.currentCursor.hasNext();
    }

    public String next() throws ResultSetException {
        ++this.count;
        return this.serializer.apply((DBObject)this.currentCursor.next());
    }

    public int getCount() {
        return this.count;
    }

    public int getTotal() {
        return this.total;
    }
}

