/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.cleaner;

import eu.dnetlib.data.cleaner.CleaningRuleFactory;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CleanerException;
import eu.dnetlib.rmi.data.CleanerService;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class CleanerServiceImpl
extends AbstractBaseService
implements CleanerService {
    private CleaningRuleFactory cleaningRuleFactory;
    @Autowired
    private ResultSetFactory resultSetFactory;

    public ResultSet<String> clean(ResultSet<String> rs, String ruleId) throws CleanerException {
        if (ruleId == null || ruleId.isEmpty()) {
            throw new CleanerException("Invalid ruleId: id is empty");
        }
        if (rs == null) {
            throw new CleanerException("Passed rs is null");
        }
        return this.resultSetFactory.map(rs, String.class, (Function)this.cleaningRuleFactory.obtainCleaningRule(ruleId));
    }

    public CleaningRuleFactory getCleaningRuleFactory() {
        return this.cleaningRuleFactory;
    }

    @Required
    public void setCleaningRuleFactory(CleaningRuleFactory cleaningRuleFactory) {
        this.cleaningRuleFactory = cleaningRuleFactory;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }
}

