/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.mongo;

import eu.dnetlib.data.collector.plugins.mongo.MongoDumpIterator;
import eu.dnetlib.rmi.data.CollectorServiceException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;

public class MongoDumpIterable
implements Iterable<String> {
    private final BufferedReader inputStream;

    public MongoDumpIterable(File inputFile) throws CollectorServiceException {
        try {
            GZIPInputStream gzipStream = new GZIPInputStream(new FileInputStream(inputFile));
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "UTF-8");
            this.inputStream = new BufferedReader(decoder);
        }
        catch (Exception e) {
            throw new CollectorServiceException("Error unable to open inputStream", (Throwable)e);
        }
    }

    @Override
    public Iterator<String> iterator() {
        return new MongoDumpIterator(this.inputStream);
    }
}

